/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.res.Configuration;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import org.mozilla.gecko.R;
import org.mozilla.gecko.home.HomeFragment;
import org.mozilla.gecko.home.LastTabsPanel;
import org.mozilla.gecko.home.MostRecentPanel;
import org.mozilla.gecko.widget.IconTabWidget;

public class HistoryPanel
extends HomeFragment
implements IconTabWidget.OnTabChangedListener {
    private static final String LOGTAG = "GeckoHistoryPanel";
    private IconTabWidget mTabWidget;
    private int mSelectedTab;
    private boolean initializeRecentPanel;

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return layoutInflater.inflate(R.layout.home_history_panel, viewGroup, false);
    }

    public void onViewCreated(View view, Bundle bundle) {
        super.onViewCreated(view, bundle);
        this.mTabWidget = (IconTabWidget)view.findViewById(R.id.tab_icon_widget);
        this.mTabWidget.addTab(R.drawable.icon_most_recent, R.string.home_most_recent_title);
        this.mTabWidget.addTab(R.drawable.icon_last_tabs, R.string.home_last_tabs_title);
        this.mTabWidget.setTabSelectionListener(this);
        this.mTabWidget.setCurrentTab(this.mSelectedTab);
        this.loadIfVisible();
    }

    public void load() {
        if (!this.initializeRecentPanel) {
            this.showMostRecentPanel();
            this.initializeRecentPanel = true;
        }
    }

    public void onTabChanged(int n) {
        if (n == this.mSelectedTab) {
            return;
        }
        if (n == 0) {
            this.showMostRecentPanel();
        } else if (n == 1) {
            this.showLastTabsPanel();
        }
        this.mTabWidget.setCurrentTab(n);
        this.mSelectedTab = n;
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        if (this.isVisible()) {
            this.getFragmentManager().beginTransaction().detach((Fragment)this).attach((Fragment)this).commitAllowingStateLoss();
        }
    }

    private void showSubPanel(Fragment fragment) {
        Bundle bundle = new Bundle();
        bundle.putBoolean("canLoad", this.getCanLoadHint());
        fragment.setArguments(bundle);
        this.getChildFragmentManager().beginTransaction().addToBackStack(null).replace(R.id.history_panel_container, fragment).commitAllowingStateLoss();
    }

    private void showMostRecentPanel() {
        MostRecentPanel mostRecentPanel = MostRecentPanel.newInstance();
        this.showSubPanel(mostRecentPanel);
    }

    private void showLastTabsPanel() {
        LastTabsPanel lastTabsPanel = LastTabsPanel.newInstance();
        this.showSubPanel(lastTabsPanel);
    }
}

