/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.database.Cursor;
import android.support.v4.widget.CursorAdapter;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import org.mozilla.gecko.R;
import org.mozilla.gecko.home.HomeConfig;
import org.mozilla.gecko.home.HomeListView;
import org.mozilla.gecko.home.PanelLayout;
import org.mozilla.gecko.home.PanelListRow;

public class PanelListView
extends HomeListView
implements PanelLayout.DatasetBacked {
    private static final String LOGTAG = "GeckoPanelListView";
    private final PanelListAdapter mAdapter;
    private final HomeConfig.ViewConfig mViewConfig;

    public PanelListView(Context context, HomeConfig.ViewConfig viewConfig) {
        super(context);
        this.mViewConfig = viewConfig;
        this.mAdapter = new PanelListAdapter(context);
        this.setAdapter((ListAdapter)this.mAdapter);
    }

    public void setDataset(Cursor cursor) {
        Log.d((String)LOGTAG, (String)("Setting dataset: " + this.mViewConfig.getDatasetId()));
        this.mAdapter.swapCursor(cursor);
    }

    private class PanelListAdapter
    extends CursorAdapter {
        public PanelListAdapter(Context context) {
            super(context, null, 0);
        }

        public void bindView(View view, Context context, Cursor cursor) {
            PanelListRow panelListRow = (PanelListRow)view;
            panelListRow.updateFromCursor(cursor);
        }

        public View newView(Context context, Cursor cursor, ViewGroup viewGroup) {
            return LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.panel_list_row, viewGroup, false);
        }
    }
}

