/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.menu;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageButton;
import org.mozilla.gecko.R;
import org.mozilla.gecko.menu.GeckoMenuItem;

public class MenuItemActionBar
extends ImageButton
implements GeckoMenuItem.Layout {
    private static final String LOGTAG = "GeckoMenuItemActionBar";
    private static Bitmap sMoreIcon;
    private static float sHalfIconWidth;
    private static float sMoreWidth;
    private static int sMoreOffset;
    private static Paint sDisabledPaint;
    private Drawable mIcon;
    private boolean mHasSubMenu = false;

    public MenuItemActionBar(Context context) {
        this(context, null);
    }

    public MenuItemActionBar(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.menuItemActionBarStyle);
    }

    public MenuItemActionBar(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        if (sMoreIcon == null) {
            Resources resources = this.getResources();
            BitmapDrawable bitmapDrawable = (BitmapDrawable)resources.getDrawable(R.drawable.menu_item_more);
            sMoreIcon = bitmapDrawable.getBitmap();
            sMoreWidth = (float)this.getResources().getDimensionPixelSize(R.dimen.menu_item_state_icon) / 2.0f;
            sMoreOffset = resources.getDimensionPixelSize(R.dimen.menu_item_more_offset);
            int n2 = resources.getDimensionPixelSize(R.dimen.menu_item_row_height);
            int n3 = this.getPaddingTop() + this.getPaddingBottom();
            sHalfIconWidth = (float)(n2 - n3) / 2.0f;
            sDisabledPaint = new Paint(1);
            sDisabledPaint.setColorFilter((ColorFilter)new PorterDuffColorFilter(-6710887, PorterDuff.Mode.SRC_ATOP));
        }
    }

    protected void onDraw(Canvas canvas) {
        float f;
        if (!this.mHasSubMenu) {
            super.onDraw(canvas);
            return;
        }
        int n = canvas.save();
        float f2 = (float)this.getMeasuredWidth() / 2.0f;
        boolean bl = (double)f2 < 1.5 * (double)(f = (float)this.getMeasuredHeight() / 2.0f);
        float f3 = bl ? ((float)sMoreOffset + sMoreWidth) / 2.0f : 0.0f;
        canvas.translate(-f3, 0.0f);
        super.onDraw(canvas);
        float f4 = f2 + sHalfIconWidth + (float)sMoreOffset - f3;
        float f5 = f - sMoreWidth;
        canvas.drawBitmap(sMoreIcon, f4, f5, this.isEnabled() ? null : sDisabledPaint);
        canvas.translate(f3, 0.0f);
        canvas.restoreToCount(n);
    }

    public void initialize(GeckoMenuItem geckoMenuItem) {
        if (geckoMenuItem == null) {
            return;
        }
        this.setIcon(geckoMenuItem.getIcon());
        this.setTitle(geckoMenuItem.getTitle());
        this.setEnabled(geckoMenuItem.isEnabled());
        this.setId(geckoMenuItem.getItemId());
        this.setSubMenuIndicator(geckoMenuItem.hasSubMenu());
    }

    void setIcon(Drawable drawable2) {
        this.mIcon = drawable2;
        if (drawable2 == null) {
            this.setVisibility(8);
        } else {
            this.setVisibility(0);
            this.setImageDrawable(drawable2);
        }
    }

    void setIcon(int n) {
        this.setIcon(n == 0 ? null : this.getResources().getDrawable(n));
    }

    void setTitle(CharSequence charSequence) {
        this.setContentDescription(charSequence);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.setColorFilter(bl ? 0 : -6710887);
    }

    public void setShowIcon(boolean bl) {
    }

    private void setSubMenuIndicator(boolean bl) {
        if (this.mHasSubMenu != bl) {
            this.mHasSubMenu = bl;
            this.invalidate();
        }
    }
}

