/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.preferences;

import android.content.Context;
import android.content.res.Resources;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import org.mozilla.gecko.R;
import org.mozilla.gecko.preferences.CustomListCategory;
import org.mozilla.gecko.preferences.CustomListPreference;
import org.mozilla.gecko.preferences.PanelsPreferenceCategory;

public class PanelsPreference
extends CustomListPreference {
    protected String LOGTAG = "PanelsPreference";
    private static final int INDEX_SHOW_BUTTON = 1;
    private static final int INDEX_REMOVE_BUTTON = 2;
    private String LABEL_HIDE;
    private String LABEL_SHOW;
    protected boolean mIsHidden = false;

    public PanelsPreference(Context context, CustomListCategory customListCategory) {
        super(context, customListCategory);
    }

    protected int getPreferenceLayoutResource() {
        return R.layout.preference_panels;
    }

    protected void onBindView(View view) {
        super.onBindView(view);
        view.setEnabled(!this.mIsHidden);
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                viewGroup.getChildAt(i).setEnabled(!this.mIsHidden);
            }
        }
    }

    protected String[] getDialogStrings() {
        Resources resources = this.getContext().getResources();
        this.LABEL_HIDE = resources.getString(R.string.pref_panels_hide);
        this.LABEL_SHOW = resources.getString(R.string.pref_panels_show);
        return new String[]{this.LABEL_SET_AS_DEFAULT, this.LABEL_HIDE};
    }

    public void setIsDefault(boolean bl) {
        this.mIsDefault = bl;
        if (bl) {
            this.setSummary(this.LABEL_IS_DEFAULT);
            if (this.mIsHidden) {
                this.setHidden(false);
            }
        } else {
            this.setSummary("");
        }
    }

    protected void onDialogIndexClicked(int n) {
        switch (n) {
            case 0: {
                this.mParentCategory.setDefault(this);
                break;
            }
            case 1: {
                ((PanelsPreferenceCategory)this.mParentCategory).setHidden(this, !this.mIsHidden);
                break;
            }
            case 2: {
                this.mParentCategory.uninstall(this);
                break;
            }
            default: {
                Log.w((String)this.LOGTAG, (String)("Selected index out of range: " + n));
            }
        }
    }

    protected void configureShownDialog() {
        super.configureShownDialog();
        TextView textView = (TextView)this.mDialog.getListView().getChildAt(1);
        textView.setText((CharSequence)(this.mIsHidden ? this.LABEL_SHOW : this.LABEL_HIDE));
    }

    public void setHidden(boolean bl) {
        if (bl) {
            this.setIsDefault(false);
        }
        if (this.mIsHidden != bl) {
            this.mIsHidden = bl;
            this.notifyChanged();
        }
    }

    public boolean isHidden() {
        return this.mIsHidden;
    }
}

