/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.preferences;

import android.app.AlertDialog;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.SpannableString;
import android.util.Log;
import android.view.View;
import android.widget.Toast;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.R;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.favicons.decoders.FaviconDecoder;
import org.mozilla.gecko.favicons.decoders.LoadFaviconResult;
import org.mozilla.gecko.preferences.CustomListPreference;
import org.mozilla.gecko.preferences.SearchPreferenceCategory;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.widget.FaviconView;

public class SearchEnginePreference
extends CustomListPreference {
    protected String LOGTAG = "SearchEnginePreference";
    protected static final int INDEX_REMOVE_BUTTON = 1;
    private BitmapDrawable mPromptIcon;
    private Bitmap mIconBitmap;
    private FaviconView mFaviconView;

    public SearchEnginePreference(Context context, SearchPreferenceCategory searchPreferenceCategory) {
        super(context, searchPreferenceCategory);
    }

    protected void onBindView(View view) {
        super.onBindView(view);
        this.mFaviconView = (FaviconView)view.findViewById(R.id.search_engine_icon);
        this.mFaviconView.updateAndScaleImage(this.mIconBitmap, ((Object)this.getTitle()).toString());
    }

    protected int getPreferenceLayoutResource() {
        return R.layout.preference_search_engine;
    }

    protected String[] getDialogStrings() {
        Resources resources = this.getContext().getResources();
        return new String[]{this.LABEL_SET_AS_DEFAULT, resources.getString(R.string.pref_dialog_remove)};
    }

    public void showDialog() {
        if (this.mParentCategory.getPreferenceCount() == 1) {
            ThreadUtils.postToUiThread((Runnable)new Runnable(){

                public void run() {
                    Toast.makeText((Context)SearchEnginePreference.this.getContext(), (int)R.string.pref_search_last_toast, (int)0).show();
                }
            });
            return;
        }
        super.showDialog();
    }

    protected void configureDialogBuilder(AlertDialog.Builder builder) {
        if (this.mPromptIcon == null && this.mIconBitmap != null) {
            this.mPromptIcon = new BitmapDrawable(this.getContext().getResources(), this.mFaviconView.getBitmap());
        }
        builder.setIcon((Drawable)this.mPromptIcon);
    }

    protected void onDialogIndexClicked(int n) {
        switch (n) {
            case 0: {
                this.mParentCategory.setDefault(this);
                break;
            }
            case 1: {
                this.mParentCategory.uninstall(this);
                break;
            }
            default: {
                Log.w((String)this.LOGTAG, (String)"Selected index out of range.");
            }
        }
    }

    public void setSearchEngineFromJSON(JSONObject jSONObject) throws JSONException {
        String string2 = jSONObject.getString("name");
        SpannableString spannableString = new SpannableString((CharSequence)string2);
        this.setTitle((CharSequence)spannableString);
        String string3 = jSONObject.getString("iconURI");
        try {
            LoadFaviconResult loadFaviconResult = FaviconDecoder.decodeDataURI(string3);
            if (loadFaviconResult == null) {
                Log.w((String)this.LOGTAG, (String)"Unable to decode icon URI.");
                return;
            }
            Iterator<Bitmap> iterator = loadFaviconResult.getBitmaps();
            if (!iterator.hasNext()) {
                Log.w((String)this.LOGTAG, (String)"No bitmaps in decoded icon.");
                return;
            }
            this.mIconBitmap = iterator.next();
            if (!iterator.hasNext()) {
                return;
            }
            int n = this.mFaviconView != null ? this.mFaviconView.getWidth() : (Favicons.sLargestFaviconSize == 0 ? 128 : Favicons.sLargestFaviconSize);
            int n2 = this.mIconBitmap.getWidth();
            while (n2 < n && iterator.hasNext()) {
                Bitmap bitmap = iterator.next();
                if (bitmap.getWidth() <= n2) continue;
                n2 = bitmap.getWidth();
                this.mIconBitmap = bitmap;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.e((String)this.LOGTAG, (String)"IllegalArgumentException creating Bitmap. Most likely a zero-length bitmap.", (Throwable)illegalArgumentException);
        }
        catch (NullPointerException nullPointerException) {
            Log.e((String)this.LOGTAG, (String)"NullPointerException creating Bitmap. Most likely a zero-length bitmap.", (Throwable)nullPointerException);
        }
    }
}

