/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.util.AttributeSet;
import android.view.View;
import org.mozilla.gecko.R;
import org.mozilla.gecko.toolbar.ShapedButton;

public class ForwardButton
extends ShapedButton {
    private Path mBorderPath;
    private Paint mBorderPaint = new Paint();
    private Paint mBorderPrivatePaint;

    public ForwardButton(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mBorderPaint.setAntiAlias(true);
        this.mBorderPaint.setColor(-16777216);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPrivatePaint = new Paint(this.mBorderPaint);
        this.mBorderPath = new Path();
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        float f = this.getContext().getResources().getDimension(R.dimen.nav_button_border_width);
        this.mBorderPaint.setStrokeWidth(f);
        this.mBorderPrivatePaint.setStrokeWidth(f);
        this.mBorderPath.reset();
        this.mBorderPath.moveTo((float)n - f, 0.0f);
        this.mBorderPath.lineTo((float)n - f, (float)n2);
        this.mBorderPaint.setShader((Shader)new LinearGradient(0.0f, 0.0f, 0.0f, (float)n2, -4867135, -328708, Shader.TileMode.CLAMP));
        this.mBorderPrivatePaint.setShader((Shader)new LinearGradient(0.0f, 0.0f, 0.0f, (float)n2, -16513529, -16052978, Shader.TileMode.CLAMP));
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        canvas.drawPath(this.mBorderPath, this.isPrivateMode() ? this.mBorderPrivatePaint : this.mBorderPaint);
    }

    public void onLightweightThemeChanged() {
        Drawable drawable2 = this.mTheme.getDrawable((View)this);
        if (drawable2 == null) {
            return;
        }
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(PRIVATE_PRESSED_STATE_SET, (Drawable)this.getColorDrawable(R.color.highlight_nav_pb));
        stateListDrawable.addState(PRESSED_ENABLED_STATE_SET, (Drawable)this.getColorDrawable(R.color.highlight_nav));
        stateListDrawable.addState(PRIVATE_FOCUSED_STATE_SET, (Drawable)this.getColorDrawable(R.color.highlight_nav_focused_pb));
        stateListDrawable.addState(FOCUSED_STATE_SET, (Drawable)this.getColorDrawable(R.color.highlight_nav_focused));
        stateListDrawable.addState(PRIVATE_STATE_SET, (Drawable)this.getColorDrawable(R.color.background_private));
        stateListDrawable.addState(EMPTY_STATE_SET, drawable2);
        this.setBackgroundDrawable((Drawable)stateListDrawable);
    }

    public void onLightweightThemeReset() {
        this.setBackgroundResource(R.drawable.url_bar_nav_button);
    }
}

