/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.CheckedTextView;
import android.widget.ListAdapter;
import android.widget.ListView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mozilla.gecko.R;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicColorPicker
extends ListView {
    private static final String LOGTAG = "GeckoBasicColorPicker";
    private static final List<Integer> DEFAULT_COLORS = Arrays.asList(Color.rgb((int)215, (int)57, (int)32), Color.rgb((int)255, (int)134, (int)5), Color.rgb((int)255, (int)203, (int)19), Color.rgb((int)95, (int)173, (int)71), Color.rgb((int)84, (int)201, (int)168), Color.rgb((int)33, (int)161, (int)222), Color.rgb((int)16, (int)36, (int)87), Color.rgb((int)91, (int)32, (int)103), Color.rgb((int)212, (int)221, (int)228), -16777216);
    private static Drawable mCheckDrawable = null;
    private int mSelected = 0;
    private final ColorPickerListAdapter mAdapter;

    public BasicColorPicker(Context context) {
        this(context, null);
    }

    public BasicColorPicker(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public BasicColorPicker(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, DEFAULT_COLORS);
    }

    public BasicColorPicker(Context context, AttributeSet attributeSet, int n, List<Integer> list) {
        super(context, attributeSet, n);
        this.mAdapter = new ColorPickerListAdapter(context, new ArrayList<Integer>(list));
        this.setAdapter((ListAdapter)this.mAdapter);
        this.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                BasicColorPicker.this.mSelected = n;
                BasicColorPicker.this.mAdapter.notifyDataSetChanged();
            }
        });
    }

    public int getColor() {
        return (Integer)this.mAdapter.getItem(this.mSelected);
    }

    public void setColor(int n) {
        if (!DEFAULT_COLORS.contains(n)) {
            this.mSelected = this.mAdapter.getCount();
            this.mAdapter.add(n);
        } else {
            this.mSelected = DEFAULT_COLORS.indexOf(n);
        }
        this.setSelection(this.mSelected);
        this.mAdapter.notifyDataSetChanged();
    }

    private Drawable getCheckDrawable() {
        if (mCheckDrawable == null) {
            Resources resources = this.getContext().getResources();
            TypedValue typedValue = new TypedValue();
            this.getContext().getTheme().resolveAttribute(16842829, typedValue, true);
            DisplayMetrics displayMetrics = new DisplayMetrics();
            ((WindowManager)this.getContext().getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
            int n = (int)typedValue.getDimension(displayMetrics);
            Drawable drawable2 = resources.getDrawable(R.drawable.color_picker_row_bg);
            Rect rect = new Rect();
            drawable2.getPadding(rect);
            mCheckDrawable = resources.getDrawable(R.drawable.color_picker_checkmark);
            mCheckDrawable.setBounds(0, 0, n -= rect.top + rect.bottom, n);
        }
        return mCheckDrawable;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ColorPickerListAdapter
    extends ArrayAdapter<Integer> {
        private final List<Integer> mColors;

        public ColorPickerListAdapter(Context context, List<Integer> list) {
            super(context, R.layout.color_picker_row, list);
            this.mColors = list;
        }

        public View getView(int n, View view, ViewGroup viewGroup) {
            View view2 = super.getView(n, view, viewGroup);
            Drawable drawable2 = view2.getBackground();
            drawable2.setColorFilter(((Integer)this.getItem(n)).intValue(), PorterDuff.Mode.MULTIPLY);
            view2.setBackground(drawable2);
            Drawable drawable3 = null;
            CheckedTextView checkedTextView = (CheckedTextView)view2;
            if (BasicColorPicker.this.mSelected == n) {
                drawable3 = BasicColorPicker.this.getCheckDrawable();
            }
            checkedTextView.setCompoundDrawables(drawable3, null, null, null);
            checkedTextView.setText((CharSequence)"");
            return view2;
        }
    }
}

