/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.os.Build;
import android.os.StrictMode;
import android.util.Log;
import java.io.File;
import java.io.FileFilter;
import java.util.Locale;
import java.util.regex.Pattern;
import org.mozilla.gecko.util.HardwareUtils;

public final class SysInfo {
    private static final String LOG_TAG = "GeckoSysInfo";
    private static volatile int cpuCount = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCPUCount() {
        if (cpuCount > 0) {
            return cpuCount;
        }
        if (Build.VERSION.SDK_INT < 9) {
            return SysInfo.readCPUCount();
        }
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        try {
            int n = SysInfo.readCPUCount();
            return n;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    private static int readCPUCount() {
        try {
            File file = new File("/sys/devices/system/cpu/");
            class CpuFilter
            implements FileFilter {
                CpuFilter() {
                }

                public boolean accept(File file) {
                    return Pattern.matches("cpu[0-9]+", file.getName());
                }
            }
            cpuCount = file.listFiles(new CpuFilter()).length;
            return cpuCount;
        }
        catch (Exception exception) {
            Log.w((String)LOG_TAG, (String)"Assuming 1 CPU; got exception.", (Throwable)exception);
            cpuCount = 1;
            return 1;
        }
    }

    public static int getMemSize() {
        return HardwareUtils.getMemSize();
    }

    public static int getVersion() {
        return Build.VERSION.SDK_INT;
    }

    public static String getReleaseVersion() {
        return Build.VERSION.RELEASE;
    }

    public static String getKernelVersion() {
        return System.getProperty("os.version", "");
    }

    public static String getManufacturer() {
        return Build.MANUFACTURER;
    }

    public static String getDevice() {
        return Build.MODEL;
    }

    public static String getHardware() {
        return Build.HARDWARE;
    }

    public static String getName() {
        return "Android";
    }

    public static String getArch() {
        return "arm";
    }

    public static String getArchABI() {
        return Build.CPU_ABI;
    }

    public static String getLocale() {
        return Locale.getDefault().toString().replace('_', '-');
    }
}

