/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.healthreport;

import org.mozilla.gecko.background.healthreport.EnvironmentV1;
import org.mozilla.gecko.background.healthreport.EnvironmentV2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Environment
extends EnvironmentV2 {
    public static final int CURRENT_VERSION = 3;
    public UIType uiType = UIType.DEFAULT;
    public int uiMode = 0;
    public int screenXInMM;
    public int screenYInMM;
    public int screenLayout = 0;
    public boolean hasHardwareKeyboard;

    public Environment() {
        this(EnvironmentV1.HashAppender.class);
    }

    public Environment(Class<? extends EnvironmentV1.EnvironmentAppender> clazz) {
        super(clazz);
        this.version = 3;
    }

    @Override
    protected void appendHash(EnvironmentV1.EnvironmentAppender environmentAppender) {
        super.appendHash(environmentAppender);
        environmentAppender.append(this.hasHardwareKeyboard ? 1 : 0);
        environmentAppender.append(this.uiType.toString());
        environmentAppender.append(this.uiMode);
        environmentAppender.append(this.screenLayout);
        environmentAppender.append(this.screenXInMM);
        environmentAppender.append(this.screenYInMM);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UIType {
        DEFAULT("default"),
        LARGE_TABLET("largetablet"),
        SMALL_TABLET("smalltablet");

        private final String label;

        private UIType(String string3) {
            this.label = string3;
        }

        public String toString() {
            return this.label;
        }

        public static UIType fromLabel(String string2) {
            for (UIType uIType : UIType.values()) {
                if (!uIType.label.equals(string2)) continue;
                return uIType;
            }
            throw new IllegalArgumentException("Bad enum value: " + string2);
        }
    }
}

