/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.login;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.json.simple.parser.ParseException;
import org.mozilla.gecko.background.fxa.FxAccountUtils;
import org.mozilla.gecko.browserid.BrowserIDKeyPair;
import org.mozilla.gecko.browserid.JSONWebTokenUtils;
import org.mozilla.gecko.fxa.FxAccountConstants;
import org.mozilla.gecko.fxa.login.Cohabiting;
import org.mozilla.gecko.fxa.login.FxAccountLoginStateMachine;
import org.mozilla.gecko.fxa.login.FxAccountLoginTransition;
import org.mozilla.gecko.fxa.login.State;
import org.mozilla.gecko.fxa.login.TokensAndKeysState;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.NonObjectJSONException;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.crypto.KeyBundle;

public class Married
extends TokensAndKeysState {
    private static final String LOG_TAG = Married.class.getSimpleName();
    protected final String certificate;
    protected final String clientState;

    public Married(String string2, String string3, byte[] byArray, byte[] byArray2, byte[] byArray3, BrowserIDKeyPair browserIDKeyPair, String string4) {
        super(State.StateLabel.Married, string2, string3, byArray, byArray2, byArray3, browserIDKeyPair);
        Utils.throwIfNull(string4);
        this.certificate = string4;
        try {
            this.clientState = FxAccountUtils.computeClientState(byArray3);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("Unable to compute client state from kB.");
        }
    }

    public ExtendedJSONObject toJSONObject() {
        ExtendedJSONObject extendedJSONObject = super.toJSONObject();
        extendedJSONObject.put("certificate", this.certificate);
        return extendedJSONObject;
    }

    public void execute(FxAccountLoginStateMachine.ExecuteDelegate executeDelegate) {
        executeDelegate.handleTransition(new FxAccountLoginTransition.LogMessage("staying married"), this);
    }

    public String generateAssertion(String string2, String string3) throws NonObjectJSONException, IOException, ParseException, GeneralSecurityException {
        String string4 = JSONWebTokenUtils.createAssertion(this.keyPair.getPrivate(), this.certificate, string2, string3, null, 9999999999999L);
        if (!FxAccountConstants.LOG_PERSONAL_INFORMATION) {
            return string4;
        }
        try {
            FxAccountConstants.pii(LOG_TAG, "Generated assertion: " + string4);
            ExtendedJSONObject extendedJSONObject = JSONWebTokenUtils.parseAssertion(string4);
            if (extendedJSONObject != null) {
                FxAccountConstants.pii(LOG_TAG, "aHeader   : " + extendedJSONObject.getObject("header"));
                FxAccountConstants.pii(LOG_TAG, "aPayload  : " + extendedJSONObject.getObject("payload"));
                FxAccountConstants.pii(LOG_TAG, "aSignature: " + extendedJSONObject.getString("signature"));
                String string5 = extendedJSONObject.getString("certificate");
                if (string5 != null) {
                    ExtendedJSONObject extendedJSONObject2 = JSONWebTokenUtils.parseCertificate(string5);
                    FxAccountConstants.pii(LOG_TAG, "cHeader   : " + extendedJSONObject2.getObject("header"));
                    FxAccountConstants.pii(LOG_TAG, "cPayload  : " + extendedJSONObject2.getObject("payload"));
                    FxAccountConstants.pii(LOG_TAG, "cSignature: " + extendedJSONObject2.getString("signature"));
                    HashMap<Long, String> hashMap = new HashMap<Long, String>();
                    hashMap.put(extendedJSONObject.getObject("payload").getLong("iat"), "aiat");
                    hashMap.put(extendedJSONObject.getObject("payload").getLong("exp"), "aexp");
                    hashMap.put(extendedJSONObject2.getObject("payload").getLong("iat"), "ciat");
                    hashMap.put(extendedJSONObject2.getObject("payload").getLong("exp"), "cexp");
                    ArrayList arrayList = new ArrayList(hashMap.keySet());
                    Collections.sort(arrayList);
                    for (Long l : arrayList) {
                        FxAccountConstants.pii(LOG_TAG, (String)hashMap.get(l) + ": " + l);
                    }
                } else {
                    FxAccountConstants.pii(LOG_TAG, "Could not parse certificate!");
                }
            } else {
                FxAccountConstants.pii(LOG_TAG, "Could not parse assertion!");
            }
        }
        catch (Exception exception) {
            FxAccountConstants.pii(LOG_TAG, "Got exception dumping assertion debug info.");
        }
        return string4;
    }

    public KeyBundle getSyncKeyBundle() throws InvalidKeyException, NoSuchAlgorithmException, UnsupportedEncodingException {
        return FxAccountUtils.generateSyncKeyBundle(this.kB);
    }

    public String getClientState() {
        if (FxAccountConstants.LOG_PERSONAL_INFORMATION) {
            FxAccountConstants.pii(LOG_TAG, "Client state: " + this.clientState);
        }
        return this.clientState;
    }

    public State makeCohabitingState() {
        return new Cohabiting(this.email, this.uid, this.sessionToken, this.kA, this.kB, this.keyPair);
    }
}

