/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.sync;

import android.accounts.Account;
import android.content.AbstractThreadedSyncAdapter;
import android.content.ContentProviderClient;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.SyncResult;
import android.os.Bundle;
import android.os.SystemClock;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountClient;
import org.mozilla.gecko.background.fxa.FxAccountClient20;
import org.mozilla.gecko.background.fxa.SkewHandler;
import org.mozilla.gecko.browserid.BrowserIDKeyPair;
import org.mozilla.gecko.fxa.FirefoxAccounts;
import org.mozilla.gecko.fxa.FxAccountConstants;
import org.mozilla.gecko.fxa.authenticator.AccountPickler;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.fxa.login.FxAccountLoginStateMachine;
import org.mozilla.gecko.fxa.login.FxAccountLoginTransition;
import org.mozilla.gecko.fxa.login.Married;
import org.mozilla.gecko.fxa.login.State;
import org.mozilla.gecko.fxa.login.StateFactory;
import org.mozilla.gecko.fxa.sync.FxAccountGlobalSession;
import org.mozilla.gecko.fxa.sync.FxAccountNotificationManager;
import org.mozilla.gecko.fxa.sync.FxAccountSchedulePolicy;
import org.mozilla.gecko.fxa.sync.SchedulePolicy;
import org.mozilla.gecko.sync.BackoffHandler;
import org.mozilla.gecko.sync.GlobalSession;
import org.mozilla.gecko.sync.PrefsBackoffHandler;
import org.mozilla.gecko.sync.SharedPreferencesClientsDataDelegate;
import org.mozilla.gecko.sync.SyncConfiguration;
import org.mozilla.gecko.sync.ThreadPool;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.crypto.KeyBundle;
import org.mozilla.gecko.sync.delegates.BaseGlobalSessionCallback;
import org.mozilla.gecko.sync.net.HawkAuthHeaderProvider;
import org.mozilla.gecko.sync.stage.GlobalSyncStage;
import org.mozilla.gecko.tokenserver.TokenServerClient;
import org.mozilla.gecko.tokenserver.TokenServerClientDelegate;
import org.mozilla.gecko.tokenserver.TokenServerException;
import org.mozilla.gecko.tokenserver.TokenServerToken;

public class FxAccountSyncAdapter
extends AbstractThreadedSyncAdapter {
    private static final String LOG_TAG = FxAccountSyncAdapter.class.getSimpleName();
    public static final String SYNC_EXTRAS_RESPECT_LOCAL_RATE_LIMIT = "respect_local_rate_limit";
    public static final String SYNC_EXTRAS_RESPECT_REMOTE_SERVER_BACKOFF = "respect_remote_server_backoff";
    protected static final int NOTIFICATION_ID = LOG_TAG.hashCode();
    private static final String PREF_BACKOFF_STORAGE_HOST = "backoffStorageHost";
    private static final int MINIMUM_SYNC_DELAY_MILLIS = 15000;
    private volatile long lastSyncRealtimeMillis = 0L;
    protected final ExecutorService executor = Executors.newSingleThreadExecutor();
    protected final FxAccountNotificationManager notificationManager = new FxAccountNotificationManager(NOTIFICATION_ID);

    public FxAccountSyncAdapter(Context context, boolean bl) {
        super(context, bl);
    }

    private boolean shouldPerformSync(BackoffHandler backoffHandler, String string2, Bundle bundle) {
        long l = backoffHandler.delayMilliseconds();
        if (l <= 0L) {
            return true;
        }
        if (bundle == null) {
            return false;
        }
        boolean bl = bundle.getBoolean("force", false);
        if (bl) {
            Logger.info(LOG_TAG, "Forced sync (" + string2 + "): overruling remaining backoff of " + l + "ms.");
        } else {
            Logger.info(LOG_TAG, "Not syncing (" + string2 + "): must wait another " + l + "ms.");
        }
        return bl;
    }

    protected void syncWithAssertion(String string2, String string3, URI uRI, final BackoffHandler backoffHandler, final SharedPreferences sharedPreferences, final KeyBundle keyBundle, String string4, final SessionCallback sessionCallback, final Bundle bundle) {
        TokenServerClientDelegate tokenServerClientDelegate = new TokenServerClientDelegate(){
            private boolean didReceiveBackoff = false;

            public String getUserAgent() {
                return "Firefox-Android-FxAccounts/32.0a1 (Nightly)";
            }

            public void handleSuccess(TokenServerToken tokenServerToken) {
                boolean bl;
                URI uRI;
                FxAccountConstants.pii(LOG_TAG, "Got token! uid is " + tokenServerToken.uid + " and endpoint is " + tokenServerToken.endpoint + ".");
                if (!this.didReceiveBackoff) {
                    backoffHandler.setEarliestNextRequest(0L);
                }
                try {
                    uRI = new URI(tokenServerToken.endpoint);
                }
                catch (URISyntaxException uRISyntaxException) {
                    this.handleError(uRISyntaxException);
                    return;
                }
                String string2 = uRI.getHost();
                PrefsBackoffHandler prefsBackoffHandler = new PrefsBackoffHandler(sharedPreferences, "sync.storage");
                sessionCallback.setBackoffHandler(prefsBackoffHandler);
                String string3 = sharedPreferences.getString(FxAccountSyncAdapter.PREF_BACKOFF_STORAGE_HOST, null);
                boolean bl2 = bl = string3 != null && string3.equalsIgnoreCase(string2);
                if (bl) {
                    Logger.debug(LOG_TAG, "Storage host is unchanged.");
                    if (!FxAccountSyncAdapter.this.shouldPerformSync(prefsBackoffHandler, "storage", bundle)) {
                        Logger.info(LOG_TAG, "Not syncing: storage server requested backoff.");
                        sessionCallback.handleAborted(null, "Storage backoff");
                        return;
                    }
                } else {
                    Logger.debug(LOG_TAG, "Received new storage host.");
                }
                prefsBackoffHandler.setEarliestNextRequest(0L);
                FxAccountGlobalSession fxAccountGlobalSession = null;
                try {
                    SharedPreferencesClientsDataDelegate sharedPreferencesClientsDataDelegate = new SharedPreferencesClientsDataDelegate(sharedPreferences);
                    if (FxAccountConstants.LOG_PERSONAL_INFORMATION) {
                        FxAccountConstants.pii(LOG_TAG, "Client device name is: '" + sharedPreferencesClientsDataDelegate.getClientName() + "'.");
                        FxAccountConstants.pii(LOG_TAG, "Client device data last modified: " + sharedPreferencesClientsDataDelegate.getLastModifiedTimestamp());
                    }
                    SkewHandler skewHandler = SkewHandler.getSkewHandlerForHostname(string2);
                    long l = skewHandler.getSkewInSeconds();
                    HawkAuthHeaderProvider hawkAuthHeaderProvider = new HawkAuthHeaderProvider(tokenServerToken.id, tokenServerToken.key.getBytes("UTF-8"), false, l);
                    Context context = FxAccountSyncAdapter.this.getContext();
                    SyncConfiguration syncConfiguration = new SyncConfiguration(tokenServerToken.uid, hawkAuthHeaderProvider, sharedPreferences, keyBundle);
                    Set<String> set = SyncConfiguration.validEngineNames();
                    syncConfiguration.stagesToSync = Utils.getStagesToSyncFromBundle(set, bundle);
                    syncConfiguration.setClusterURL(uRI);
                    fxAccountGlobalSession = new FxAccountGlobalSession(syncConfiguration, sessionCallback, context, sharedPreferencesClientsDataDelegate);
                    fxAccountGlobalSession.start();
                }
                catch (Exception exception) {
                    sessionCallback.handleError(fxAccountGlobalSession, exception);
                    return;
                }
            }

            public void handleFailure(TokenServerException tokenServerException) {
                this.handleError(tokenServerException);
            }

            public void handleError(Exception exception) {
                Logger.error(LOG_TAG, "Failed to get token.", exception);
                sessionCallback.handleError(null, exception);
            }

            public void handleBackoff(int n) {
                Logger.info(LOG_TAG, "Token server requesting backoff of " + n + "s. Backoff handler: " + backoffHandler);
                this.didReceiveBackoff = true;
                backoffHandler.setEarliestNextRequest(this.delay(n * 1000));
            }

            private long delay(long l) {
                return System.currentTimeMillis() + l;
            }
        };
        TokenServerClient tokenServerClient = new TokenServerClient(uRI, this.executor);
        tokenServerClient.getTokenFromBrowserIDAssertion(string3, true, string4, tokenServerClientDelegate);
    }

    public void onPerformSync(Account account, final Bundle bundle, String string2, ContentProviderClient contentProviderClient, SyncResult syncResult) {
        Logger.setThreadLogTag("FxAccounts");
        Logger.resetLogging();
        Logger.info(LOG_TAG, "Syncing FxAccount account named like " + Utils.obfuscateEmail(account.name) + " for authority " + string2 + " with instance " + (Object)((Object)this) + ".");
        EnumSet<FirefoxAccounts.SyncHint> enumSet = FirefoxAccounts.getHintsToSyncFromBundle(bundle);
        FirefoxAccounts.logSyncHints(enumSet);
        if (this.lastSyncRealtimeMillis > 0L && this.lastSyncRealtimeMillis + 15000L > SystemClock.elapsedRealtime()) {
            Logger.info(LOG_TAG, "Not syncing FxAccount " + Utils.obfuscateEmail(account.name) + ": minimum interval not met.");
            return;
        }
        final Context context = this.getContext();
        final AndroidFxAccount androidFxAccount = new AndroidFxAccount(context, account);
        if (FxAccountConstants.LOG_PERSONAL_INFORMATION) {
            androidFxAccount.dump();
        }
        ThreadPool.run(new Runnable(){

            public void run() {
                try {
                    AccountPickler.pickle(androidFxAccount, "fxa.account.json");
                }
                catch (Exception exception) {
                    Logger.warn(LOG_TAG, "Got exception pickling current account details; ignoring.", exception);
                }
            }
        });
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Set<String> set = SyncConfiguration.validEngineNames();
        Collection<String> collection = Utils.getStagesToSyncFromBundle(set, bundle);
        final SyncDelegate syncDelegate = new SyncDelegate(countDownLatch, syncResult, androidFxAccount, collection);
        try {
            boolean bl;
            State state;
            try {
                state = androidFxAccount.getState();
            }
            catch (Exception exception) {
                syncDelegate.handleError(exception);
                return;
            }
            final SharedPreferences sharedPreferences = androidFxAccount.getSyncPrefs();
            PrefsBackoffHandler prefsBackoffHandler = new PrefsBackoffHandler(sharedPreferences, "background");
            PrefsBackoffHandler prefsBackoffHandler2 = new PrefsBackoffHandler(sharedPreferences, "rate");
            boolean bl2 = bl = bundle != null && (bundle.getBoolean("upload", false) || bundle.getBoolean("force", false));
            if (!bl && !this.shouldPerformSync(prefsBackoffHandler, "background", bundle)) {
                syncDelegate.rejectSync();
                return;
            }
            if (!this.shouldPerformSync(prefsBackoffHandler2, "rate", bundle)) {
                syncDelegate.postponeSync(prefsBackoffHandler2.delayMilliseconds());
                return;
            }
            final FxAccountSchedulePolicy fxAccountSchedulePolicy = new FxAccountSchedulePolicy(context, androidFxAccount);
            fxAccountSchedulePolicy.configureBackoffMillisBeforeSyncing(prefsBackoffHandler2, prefsBackoffHandler);
            final String string3 = androidFxAccount.getAudience();
            String string4 = androidFxAccount.getAccountServerURI();
            String string5 = androidFxAccount.getTokenServerURI();
            final URI uRI = new URI(string5);
            final FxAccountClient20 fxAccountClient20 = new FxAccountClient20(string4, this.executor);
            FxAccountLoginStateMachine fxAccountLoginStateMachine = new FxAccountLoginStateMachine();
            fxAccountLoginStateMachine.advance(state, State.StateLabel.Married, new FxAccountLoginStateMachine.LoginStateMachineDelegate(){

                public FxAccountClient getClient() {
                    return fxAccountClient20;
                }

                public long getCertificateDurationInMilliseconds() {
                    return 43200000L;
                }

                public long getAssertionDurationInMilliseconds() {
                    return 900000L;
                }

                public BrowserIDKeyPair generateKeyPair() throws NoSuchAlgorithmException {
                    return StateFactory.generateKeyPair();
                }

                public void handleTransition(FxAccountLoginTransition.Transition transition, State state) {
                    Logger.info(LOG_TAG, "handleTransition: " + transition + " to " + (Object)((Object)state.getStateLabel()));
                }

                private boolean shouldRequestToken(BackoffHandler backoffHandler, Bundle bundle2) {
                    return FxAccountSyncAdapter.this.shouldPerformSync(backoffHandler, "token", bundle2);
                }

                public void handleFinal(State state) {
                    Logger.info(LOG_TAG, "handleFinal: in " + (Object)((Object)state.getStateLabel()));
                    androidFxAccount.setState(state);
                    fxAccountSchedulePolicy.onHandleFinal(state.getNeededAction());
                    FxAccountSyncAdapter.this.notificationManager.update(context, androidFxAccount);
                    try {
                        if (state.getStateLabel() != State.StateLabel.Married) {
                            syncDelegate.handleCannotSync(state);
                            return;
                        }
                        Married married = (Married)state;
                        String string2 = married.generateAssertion(string3, "127.0.0.1");
                        PrefsBackoffHandler prefsBackoffHandler = new PrefsBackoffHandler(sharedPreferences, "token");
                        if (!this.shouldRequestToken(prefsBackoffHandler, bundle)) {
                            Logger.info(LOG_TAG, "Not syncing (token server).");
                            syncDelegate.postponeSync(prefsBackoffHandler.delayMilliseconds());
                            return;
                        }
                        SessionCallback sessionCallback = new SessionCallback(syncDelegate, fxAccountSchedulePolicy);
                        KeyBundle keyBundle = married.getSyncKeyBundle();
                        String string32 = married.getClientState();
                        FxAccountSyncAdapter.this.syncWithAssertion(string3, string2, uRI, prefsBackoffHandler, sharedPreferences, keyBundle, string32, sessionCallback, bundle);
                    }
                    catch (Exception exception) {
                        syncDelegate.handleError(exception);
                        return;
                    }
                }
            });
            countDownLatch.await();
        }
        catch (Exception exception) {
            Logger.error(LOG_TAG, "Got error syncing.", exception);
            syncDelegate.handleError(exception);
        }
        Logger.info(LOG_TAG, "Syncing done.");
        this.lastSyncRealtimeMillis = SystemClock.elapsedRealtime();
    }

    protected static class SessionCallback
    implements BaseGlobalSessionCallback {
        protected final SyncDelegate syncDelegate;
        protected final SchedulePolicy schedulePolicy;
        protected volatile BackoffHandler storageBackoffHandler;

        public SessionCallback(SyncDelegate syncDelegate, SchedulePolicy schedulePolicy) {
            this.syncDelegate = syncDelegate;
            this.schedulePolicy = schedulePolicy;
        }

        public void setBackoffHandler(BackoffHandler backoffHandler) {
            this.storageBackoffHandler = backoffHandler;
        }

        public boolean shouldBackOffStorage() {
            return this.storageBackoffHandler.delayMilliseconds() > 0L;
        }

        public void requestBackoff(long l) {
            this.schedulePolicy.configureBackoffMillisOnBackoff(this.storageBackoffHandler, l, true);
        }

        public void informUpgradeRequiredResponse(GlobalSession globalSession) {
            this.schedulePolicy.onUpgradeRequired();
        }

        public void informUnauthorizedResponse(GlobalSession globalSession, URI uRI) {
            this.schedulePolicy.onUnauthorized();
        }

        public void handleStageCompleted(GlobalSyncStage.Stage stage, GlobalSession globalSession) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleSuccess(GlobalSession globalSession) {
            Logger.info(LOG_TAG, "Global session succeeded.");
            try {
                int n = globalSession.getClientsDelegate().getClientsCount();
                Logger.debug(LOG_TAG, "" + n + " other client(s).");
                this.schedulePolicy.onSuccessfulSync(n);
            }
            finally {
                this.syncDelegate.handleSuccess();
            }
        }

        public void handleError(GlobalSession globalSession, Exception exception) {
            Logger.warn(LOG_TAG, "Global session failed.");
            this.syncDelegate.handleError(exception);
        }

        public void handleAborted(GlobalSession globalSession, String string2) {
            Logger.warn(LOG_TAG, "Global session aborted: " + string2);
            this.syncDelegate.handleError(null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SyncDelegate {
        protected final CountDownLatch latch;
        protected final SyncResult syncResult;
        protected final AndroidFxAccount fxAccount;
        protected final Collection<String> stageNamesToSync;

        public SyncDelegate(CountDownLatch countDownLatch, SyncResult syncResult, AndroidFxAccount androidFxAccount, Collection<String> collection) {
            if (countDownLatch == null) {
                throw new IllegalArgumentException("latch must not be null");
            }
            if (syncResult == null) {
                throw new IllegalArgumentException("syncResult must not be null");
            }
            if (androidFxAccount == null) {
                throw new IllegalArgumentException("fxAccount must not be null");
            }
            this.latch = countDownLatch;
            this.syncResult = syncResult;
            this.fxAccount = androidFxAccount;
            this.stageNamesToSync = Collections.unmodifiableCollection(collection);
        }

        protected void setSyncResultSuccess() {
            ++this.syncResult.stats.numUpdates;
        }

        protected void setSyncResultSoftError() {
            ++this.syncResult.stats.numUpdates;
            ++this.syncResult.stats.numIoExceptions;
        }

        protected void setSyncResultHardError() {
            ++this.syncResult.stats.numAuthExceptions;
        }

        public void handleSuccess() {
            Logger.info(LOG_TAG, "Sync succeeded.");
            this.setSyncResultSuccess();
            this.latch.countDown();
        }

        public void handleError(Exception exception) {
            State state;
            Logger.error(LOG_TAG, "Got exception syncing.", exception);
            this.setSyncResultSoftError();
            if (exception instanceof TokenServerException && (state = this.fxAccount.getState()).getStateLabel() == State.StateLabel.Married) {
                Married married = (Married)state;
                this.fxAccount.setState(married.makeCohabitingState());
            }
            this.latch.countDown();
        }

        public void handleCannotSync(State state) {
            Logger.warn(LOG_TAG, "Cannot sync from state: " + (Object)((Object)state.getStateLabel()));
            this.setSyncResultSoftError();
            this.latch.countDown();
        }

        public void postponeSync(long l) {
            if (l <= 0L) {
                Logger.debug(LOG_TAG, "Asked to postpone sync, but zero delay. Short-circuiting.");
            }
            this.setSyncResultSoftError();
            this.latch.countDown();
        }

        public void rejectSync() {
            this.latch.countDown();
        }

        public Collection<String> getStageNamesToSync() {
            return this.stageNamesToSync;
        }
    }
}

