/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.graphics.Point;
import android.graphics.PointF;
import org.json.JSONException;
import org.json.JSONObject;

public final class PointUtils {
    public static PointF add(PointF pointF, PointF pointF2) {
        return new PointF(pointF.x + pointF2.x, pointF.y + pointF2.y);
    }

    public static PointF subtract(PointF pointF, PointF pointF2) {
        return new PointF(pointF.x - pointF2.x, pointF.y - pointF2.y);
    }

    public static PointF scale(PointF pointF, float f) {
        return new PointF(pointF.x * f, pointF.y * f);
    }

    public static Point round(PointF pointF) {
        return new Point(Math.round(pointF.x), Math.round(pointF.y));
    }

    public static float distance(PointF pointF) {
        return (float)Math.sqrt(pointF.x * pointF.x + pointF.y * pointF.y);
    }

    public static float distance(PointF pointF, PointF pointF2) {
        return PointF.length((float)(pointF.x - pointF2.x), (float)(pointF.y - pointF2.y));
    }

    public static JSONObject toJSON(PointF pointF) throws JSONException {
        int n = Math.round(pointF.x);
        int n2 = Math.round(pointF.y);
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("x", n);
        jSONObject.put("y", n2);
        return jSONObject;
    }
}

