/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.util.Log;
import android.view.View;
import org.mozilla.gecko.home.HomeConfig;
import org.mozilla.gecko.home.HomePager;
import org.mozilla.gecko.home.PanelLayout;

class FramePanelLayout
extends PanelLayout {
    private static final String LOGTAG = "GeckoFramePanelLayout";
    private final View mChildView;
    private final HomeConfig.ViewConfig mChildConfig;

    public FramePanelLayout(Context context, HomeConfig.PanelConfig panelConfig, PanelLayout.DatasetHandler datasetHandler, HomePager.OnUrlOpenListener onUrlOpenListener, PanelLayout.ContextMenuRegistry contextMenuRegistry) {
        super(context, panelConfig, datasetHandler, onUrlOpenListener, contextMenuRegistry);
        this.mChildConfig = panelConfig.getViewAt(0);
        if (this.mChildConfig == null) {
            throw new IllegalStateException("FramePanelLayout requires a view in PanelConfig");
        }
        this.mChildView = this.createPanelView(this.mChildConfig);
        this.addView(this.mChildView);
    }

    public void load() {
        Log.d((String)LOGTAG, (String)"Loading");
        if (this.mChildView instanceof PanelLayout.DatasetBacked) {
            PanelLayout.FilterDetail filterDetail = new PanelLayout.FilterDetail(this.mChildConfig.getFilter(), null);
            PanelLayout.DatasetRequest datasetRequest = new PanelLayout.DatasetRequest(this.mChildConfig.getIndex(), this.mChildConfig.getDatasetId(), filterDetail);
            Log.d((String)LOGTAG, (String)("Requesting child request: " + datasetRequest));
            this.requestDataset(datasetRequest);
        }
    }
}

