/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.util.EnumSet;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.home.BrowserSearch;
import org.mozilla.gecko.home.HomePager;
import org.mozilla.gecko.home.SearchEngine;
import org.mozilla.gecko.util.StringUtils;
import org.mozilla.gecko.widget.AnimatedHeightLayout;
import org.mozilla.gecko.widget.FaviconView;
import org.mozilla.gecko.widget.FlowLayout;

class SearchEngineRow
extends AnimatedHeightLayout {
    private static final int ANIMATION_DURATION = 250;
    private final FlowLayout mSuggestionView;
    private final FaviconView mIconView;
    private final LinearLayout mUserEnteredView;
    private final TextView mUserEnteredTextView;
    private final LayoutInflater mInflater;
    private SearchEngine mSearchEngine;
    private final View.OnClickListener mClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            String string2 = SearchEngineRow.this.getSuggestionTextFromView(view);
            if (view != SearchEngineRow.this.mUserEnteredView && !StringUtils.isSearchQuery((String)string2, (boolean)false)) {
                if (SearchEngineRow.this.mUrlOpenListener != null) {
                    Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.SUGGESTION, "url");
                    SearchEngineRow.this.mUrlOpenListener.onUrlOpen(string2, EnumSet.noneOf(HomePager.OnUrlOpenListener.Flags.class));
                }
            } else if (SearchEngineRow.this.mSearchListener != null) {
                if (view == SearchEngineRow.this.mUserEnteredView) {
                    Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.SUGGESTION, "user");
                } else {
                    Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.SUGGESTION, "engine");
                }
                SearchEngineRow.this.mSearchListener.onSearch(SearchEngineRow.this.mSearchEngine, string2);
            }
        }
    };
    private final View.OnLongClickListener mLongClickListener = new View.OnLongClickListener(){

        public boolean onLongClick(View view) {
            if (SearchEngineRow.this.mEditSuggestionListener != null) {
                String string2 = SearchEngineRow.this.getSuggestionTextFromView(view);
                SearchEngineRow.this.mEditSuggestionListener.onEditSuggestion(string2);
                return true;
            }
            return false;
        }
    };
    private HomePager.OnUrlOpenListener mUrlOpenListener;
    private BrowserSearch.OnSearchListener mSearchListener;
    private BrowserSearch.OnEditSuggestionListener mEditSuggestionListener;
    private int mSelectedView = 0;

    public SearchEngineRow(Context context) {
        this(context, null);
    }

    public SearchEngineRow(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public SearchEngineRow(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.mInflater = LayoutInflater.from((Context)context);
        this.mInflater.inflate(R.layout.search_engine_row, (ViewGroup)this);
        this.mSuggestionView = (FlowLayout)this.findViewById(R.id.suggestion_layout);
        this.mIconView = (FaviconView)this.findViewById(R.id.suggestion_icon);
        this.mUserEnteredView = (LinearLayout)this.findViewById(R.id.suggestion_user_entered);
        this.mUserEnteredView.setOnClickListener(this.mClickListener);
        this.mUserEnteredTextView = (TextView)this.findViewById(R.id.suggestion_text);
    }

    private void setDescriptionOnSuggestion(View view, String string2) {
        view.setContentDescription((CharSequence)this.getResources().getString(R.string.suggestion_for_engine, new Object[]{this.mSearchEngine.name, string2}));
    }

    private String getSuggestionTextFromView(View view) {
        TextView textView = (TextView)view.findViewById(R.id.suggestion_text);
        return ((Object)textView.getText()).toString();
    }

    private void setSuggestionOnView(View view, String string2) {
        TextView textView = (TextView)view.findViewById(R.id.suggestion_text);
        textView.setText((CharSequence)string2);
        this.setDescriptionOnSuggestion((View)textView, string2);
    }

    public void performUserEnteredSearch() {
        String string2 = this.getSuggestionTextFromView((View)this.mUserEnteredView);
        if (this.mSearchListener != null) {
            Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.SUGGESTION, "user");
            this.mSearchListener.onSearch(this.mSearchEngine, string2);
        }
    }

    public void setSearchTerm(String string2) {
        this.mUserEnteredTextView.setText((CharSequence)string2);
        if (this.mSearchEngine != null) {
            this.setDescriptionOnSuggestion((View)this.mUserEnteredTextView, string2);
        }
    }

    public void setOnUrlOpenListener(HomePager.OnUrlOpenListener onUrlOpenListener) {
        this.mUrlOpenListener = onUrlOpenListener;
    }

    public void setOnSearchListener(BrowserSearch.OnSearchListener onSearchListener) {
        this.mSearchListener = onSearchListener;
    }

    public void setOnEditSuggestionListener(BrowserSearch.OnEditSuggestionListener onEditSuggestionListener) {
        this.mEditSuggestionListener = onEditSuggestionListener;
    }

    public void updateFromSearchEngine(SearchEngine searchEngine, boolean bl) {
        this.mSearchEngine = searchEngine;
        this.mIconView.updateAndScaleImage(this.mSearchEngine.getIcon(), this.mSearchEngine.getEngineIdentifier());
        this.setDescriptionOnSuggestion((View)this.mUserEnteredTextView, ((Object)this.mUserEnteredTextView.getText()).toString());
        int n = this.mSuggestionView.getChildCount();
        int n2 = 0;
        for (String string2 : this.mSearchEngine.getSuggestions()) {
            ImageView imageView;
            View view;
            if (n2 + 1 < n) {
                view = this.mSuggestionView.getChildAt(n2 + 1);
                view.setVisibility(0);
            } else {
                view = this.mInflater.inflate(R.layout.suggestion_item, null);
                view.setOnClickListener(this.mClickListener);
                view.setOnLongClickListener(this.mLongClickListener);
                imageView = (ImageView)view.findViewById(R.id.suggestion_magnifier);
                imageView.setVisibility(8);
                this.mSuggestionView.addView(view);
            }
            this.setSuggestionOnView(view, string2);
            if (bl) {
                imageView = new AlphaAnimation(0.0f, 1.0f);
                imageView.setDuration(250L);
                imageView.setStartOffset((long)(n2 * 250));
                view.startAnimation((Animation)imageView);
            }
            ++n2;
        }
        for (int i = n2 + 1; i < n; ++i) {
            this.mSuggestionView.getChildAt(i).setVisibility(8);
        }
        if (this.mSelectedView >= this.mSuggestionView.getChildCount()) {
            this.mSelectedView = this.mSuggestionView.getChildCount() - 1;
        }
    }

    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        View view = this.mSuggestionView.getChildAt(this.mSelectedView);
        if (keyEvent.getAction() != 0) {
            return false;
        }
        switch (keyEvent.getKeyCode()) {
            case 22: {
                View view2 = this.mSuggestionView.getChildAt(this.mSelectedView + 1);
                if (view2 == null) break;
                this.changeSelectedSuggestion(view, view2);
                ++this.mSelectedView;
                return true;
            }
            case 21: {
                View view3 = this.mSuggestionView.getChildAt(this.mSelectedView - 1);
                if (view3 == null) break;
                this.changeSelectedSuggestion(view, view3);
                --this.mSelectedView;
                return true;
            }
            case 96: {
                return view.performClick();
            }
        }
        return false;
    }

    private void changeSelectedSuggestion(View view, View view2) {
        view.setDuplicateParentStateEnabled(false);
        view2.setDuplicateParentStateEnabled(true);
        view.refreshDrawableState();
        view2.refreshDrawableState();
    }

    public void onSelected() {
        this.mSelectedView = 0;
        this.mUserEnteredView.setDuplicateParentStateEnabled(true);
        this.mUserEnteredView.refreshDrawableState();
    }

    public void onDeselected() {
        View view = this.mSuggestionView.getChildAt(this.mSelectedView);
        view.setDuplicateParentStateEnabled(false);
        view.refreshDrawableState();
    }
}

