/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.home.SimpleCursorLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SearchLoader {
    private static final String KEY_SEARCH_TERM = "search_term";

    private SearchLoader() {
    }

    public static Loader<Cursor> createInstance(Context context, Bundle bundle) {
        if (bundle != null) {
            String string2 = bundle.getString(KEY_SEARCH_TERM);
            return new SearchCursorLoader(context, string2);
        }
        return new SearchCursorLoader(context, "");
    }

    private static Bundle createArgs(String string2) {
        Bundle bundle = new Bundle();
        bundle.putString(KEY_SEARCH_TERM, string2);
        return bundle;
    }

    public static void init(LoaderManager loaderManager, int n, LoaderManager.LoaderCallbacks<Cursor> loaderCallbacks, String string2) {
        Bundle bundle = SearchLoader.createArgs(string2);
        loaderManager.initLoader(n, bundle, loaderCallbacks);
    }

    public static void restart(LoaderManager loaderManager, int n, LoaderManager.LoaderCallbacks<Cursor> loaderCallbacks, String string2) {
        Bundle bundle = SearchLoader.createArgs(string2);
        loaderManager.restartLoader(n, bundle, loaderCallbacks);
    }

    public static class SearchCursorLoader
    extends SimpleCursorLoader {
        private static final int SEARCH_LIMIT = 100;
        private final String mSearchTerm;

        public SearchCursorLoader(Context context, String string2) {
            super(context);
            this.mSearchTerm = string2;
        }

        public Cursor loadCursor() {
            return BrowserDB.filter(this.getContext().getContentResolver(), this.mSearchTerm, 100);
        }

        public String getSearchTerm() {
            return this.mSearchTerm;
        }
    }
}

