/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.preferences;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.preference.DialogPreference;
import android.util.AttributeSet;
import android.widget.Button;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.R;
import org.mozilla.gecko.util.ThreadUtils;

class MultiChoicePreference
extends DialogPreference {
    private static final String LOGTAG = "GeckoMultiChoicePreference";
    private boolean[] mValues;
    private boolean[] mPrevValues;
    private CharSequence[] mEntryKeys;
    private CharSequence[] mEntries;
    private CharSequence[] mInitialValues;

    public MultiChoicePreference(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.MultiChoicePreference);
        this.mEntries = typedArray.getTextArray(0);
        this.mEntryKeys = typedArray.getTextArray(1);
        this.mInitialValues = typedArray.getTextArray(2);
        typedArray.recycle();
        this.loadPersistedValues();
    }

    public MultiChoicePreference(Context context) {
        this(context, null);
    }

    public void setEntries(CharSequence[] charSequenceArray) {
        this.mEntries = (CharSequence[])charSequenceArray.clone();
    }

    public void setEntries(int n) {
        this.setEntries(this.getContext().getResources().getTextArray(n));
    }

    public void setEntryKeys(CharSequence[] charSequenceArray) {
        this.mEntryKeys = (CharSequence[])charSequenceArray.clone();
        this.loadPersistedValues();
    }

    public void setEntryKeys(int n) {
        this.setEntryKeys(this.getContext().getResources().getTextArray(n));
    }

    public void setInitialValues(CharSequence[] charSequenceArray) {
        this.mInitialValues = (CharSequence[])charSequenceArray.clone();
        this.loadPersistedValues();
    }

    public void setInitialValues(int n) {
        this.setInitialValues(this.getContext().getResources().getTextArray(n));
    }

    public CharSequence[] getEntries() {
        return (CharSequence[])this.mEntries.clone();
    }

    public CharSequence[] getEntryKeys() {
        return (CharSequence[])this.mEntryKeys.clone();
    }

    public CharSequence[] getInitialValues() {
        return (CharSequence[])this.mInitialValues.clone();
    }

    public boolean[] getValues() {
        return (boolean[])this.mValues.clone();
    }

    protected void onPrepareDialogBuilder(AlertDialog.Builder builder) {
        if (this.mEntries == null || this.mEntryKeys == null || this.mInitialValues == null) {
            throw new IllegalStateException("MultiChoicePreference requires entries, entryKeys, and initialValues arrays.");
        }
        if (this.mEntries.length != this.mEntryKeys.length || this.mEntryKeys.length != this.mInitialValues.length) {
            throw new IllegalStateException("MultiChoicePreference entries, entryKeys, and initialValues arrays must be the same length");
        }
        builder.setMultiChoiceItems(this.mEntries, this.mValues, new DialogInterface.OnMultiChoiceClickListener(){

            public void onClick(DialogInterface dialogInterface, int n, boolean bl) {
                Button button;
                boolean bl2 = false;
                for (int i = 0; i < MultiChoicePreference.this.mValues.length; ++i) {
                    if (!MultiChoicePreference.this.mValues[i]) continue;
                    bl2 = true;
                    break;
                }
                if ((button = ((AlertDialog)dialogInterface).getButton(-1)).isEnabled() != bl2) {
                    button.setEnabled(bl2);
                }
            }
        });
    }

    protected void onDialogClosed(boolean bl) {
        if (this.mPrevValues == null || this.mInitialValues == null) {
            return;
        }
        if (!bl) {
            this.mValues = (boolean[])this.mPrevValues.clone();
            return;
        }
        this.mPrevValues = (boolean[])this.mValues.clone();
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            public void run() {
                for (int i = 0; i < MultiChoicePreference.this.mEntryKeys.length; ++i) {
                    String string2 = ((Object)MultiChoicePreference.this.mEntryKeys[i]).toString();
                    MultiChoicePreference.this.persistBoolean(string2, MultiChoicePreference.this.mValues[i]);
                }
            }
        });
    }

    protected boolean persistBoolean(String string2, boolean bl) {
        if (this.isPersistent()) {
            if (bl == this.getPersistedBoolean(!bl)) {
                return true;
            }
            GeckoSharedPrefs.forApp(this.getContext()).edit().putBoolean(string2, bl).commit();
            return true;
        }
        return false;
    }

    protected boolean getPersistedBoolean(String string2, boolean bl) {
        if (!this.isPersistent()) {
            return bl;
        }
        return GeckoSharedPrefs.forApp(this.getContext()).getBoolean(string2, bl);
    }

    private void loadPersistedValues() {
        if (this.mEntryKeys == null || this.mInitialValues == null) {
            return;
        }
        final int n = this.mEntryKeys.length;
        if (n != this.mEntries.length || n != this.mInitialValues.length) {
            throw new IllegalStateException("MultiChoicePreference entryKeys and initialValues arrays must be the same length");
        }
        this.mValues = new boolean[n];
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            public void run() {
                for (int i = 0; i < n; ++i) {
                    String string2 = ((Object)MultiChoicePreference.this.mEntryKeys[i]).toString();
                    boolean bl = MultiChoicePreference.this.mInitialValues[i].equals("true");
                    ((MultiChoicePreference)MultiChoicePreference.this).mValues[i] = MultiChoicePreference.this.getPersistedBoolean(string2, bl);
                }
                MultiChoicePreference.access$302(MultiChoicePreference.this, (boolean[])MultiChoicePreference.this.mValues.clone());
            }
        });
    }

    static /* synthetic */ boolean[] access$302(MultiChoicePreference multiChoicePreference, boolean[] blArray) {
        multiChoicePreference.mPrevValues = blArray;
        return blArray;
    }
}

