/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.prompts;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TabHost;
import android.widget.TextView;
import java.util.LinkedHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.R;
import org.mozilla.gecko.prompts.PromptInput;
import org.mozilla.gecko.prompts.PromptListAdapter;
import org.mozilla.gecko.prompts.PromptListItem;
import org.mozilla.gecko.util.ThreadUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabInput
extends PromptInput
implements AdapterView.OnItemClickListener {
    public static final String INPUT_TYPE = "tabs";
    public static final String LOGTAG = "GeckoTabInput";
    private final LinkedHashMap<String, PromptListItem[]> mTabs = new LinkedHashMap();
    private TabHost mHost;
    private int mPosition;

    public TabInput(JSONObject jSONObject) {
        super(jSONObject);
        try {
            JSONArray jSONArray = jSONObject.getJSONArray("items");
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                String string2 = jSONObject2.getString("label");
                JSONArray jSONArray2 = jSONObject2.getJSONArray("items");
                this.mTabs.put(string2, PromptListItem.getArray(jSONArray2));
            }
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"Exception", (Throwable)jSONException);
        }
    }

    @Override
    public View getView(final Context context) throws UnsupportedOperationException {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        this.mHost = (TabHost)layoutInflater.inflate(R.layout.tab_prompt_input, null);
        this.mHost.setup();
        for (String string2 : this.mTabs.keySet()) {
            TabHost.TabSpec tabSpec = this.mHost.newTabSpec(string2);
            tabSpec.setContent(new TabHost.TabContentFactory(){

                public View createTabContent(String string2) {
                    PromptListAdapter promptListAdapter = new PromptListAdapter(context, 17367043, (PromptListItem[])TabInput.this.mTabs.get(string2));
                    ListView listView = new ListView(context);
                    listView.setCacheColorHint(0);
                    listView.setOnItemClickListener((AdapterView.OnItemClickListener)TabInput.this);
                    listView.setAdapter((ListAdapter)promptListAdapter);
                    return listView;
                }
            });
            if (Build.VERSION.SDK_INT < 11) {
                TextView textView = (TextView)layoutInflater.inflate(R.layout.tab_prompt_tab, null);
                textView.setText((CharSequence)string2);
                tabSpec.setIndicator((View)textView);
            } else {
                tabSpec.setIndicator((CharSequence)string2);
            }
            this.mHost.addTab(tabSpec);
        }
        this.mView = this.mHost;
        return this.mHost;
    }

    @Override
    public Object getValue() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("tab", this.mHost.getCurrentTab());
            jSONObject.put("item", this.mPosition);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    @Override
    public boolean getScrollable() {
        return true;
    }

    @Override
    public boolean canApplyInputStyle() {
        return false;
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
        ThreadUtils.assertOnUiThread();
        this.mPosition = n;
        this.notifyListeners(Integer.toString(n));
    }
}

