/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.net;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HttpEntity;
import ch.boye.httpclientandroidlib.HttpEntityEnclosingRequest;
import ch.boye.httpclientandroidlib.client.methods.HttpRequestBase;
import ch.boye.httpclientandroidlib.client.methods.HttpUriRequest;
import ch.boye.httpclientandroidlib.impl.client.DefaultHttpClient;
import ch.boye.httpclientandroidlib.message.BasicHeader;
import ch.boye.httpclientandroidlib.protocol.BasicHttpContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.mozilla.apache.commons.codec.binary.Base64;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.net.AuthHeaderProvider;

public class HawkAuthHeaderProvider
implements AuthHeaderProvider {
    public static final String LOG_TAG = HawkAuthHeaderProvider.class.getSimpleName();
    public static final int HAWK_HEADER_VERSION = 1;
    protected static final int NONCE_LENGTH_IN_BYTES = 8;
    protected static final String HMAC_SHA256_ALGORITHM = "hmacSHA256";
    protected final String id;
    protected final byte[] key;
    protected final boolean includePayloadHash;
    protected final long skewSeconds;

    public HawkAuthHeaderProvider(String string2, byte[] byArray, boolean bl, long l) {
        if (string2 == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        this.id = string2;
        this.key = byArray;
        this.includePayloadHash = bl;
        this.skewSeconds = l;
    }

    protected long now() {
        return System.currentTimeMillis();
    }

    protected long getTimestampSeconds() {
        return this.now() / 1000L + this.skewSeconds;
    }

    public Header getAuthHeader(HttpRequestBase httpRequestBase, BasicHttpContext basicHttpContext, DefaultHttpClient defaultHttpClient) throws GeneralSecurityException {
        long l = this.getTimestampSeconds();
        String string2 = Base64.encodeBase64String((byte[])Utils.generateRandomBytes(8));
        String string3 = "";
        try {
            return this.getAuthHeader(httpRequestBase, basicHttpContext, defaultHttpClient, l, string2, string3, this.includePayloadHash);
        }
        catch (Exception exception) {
            throw new GeneralSecurityException(exception);
        }
    }

    protected Header getAuthHeader(HttpRequestBase httpRequestBase, BasicHttpContext basicHttpContext, DefaultHttpClient defaultHttpClient, long l, String string2, String string3, boolean bl) throws InvalidKeyException, NoSuchAlgorithmException, IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("timestamp must contain only [0-9].");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("nonce must not be null.");
        }
        if (string2.length() == 0) {
            throw new IllegalArgumentException("nonce must not be empty.");
        }
        String string4 = null;
        if (bl) {
            string4 = HawkAuthHeaderProvider.getPayloadHashString(httpRequestBase);
        } else {
            Logger.debug(LOG_TAG, "Configured to not include payload hash for this request.");
        }
        String string5 = null;
        String string6 = null;
        String string7 = HawkAuthHeaderProvider.getRequestString((HttpUriRequest)httpRequestBase, "header", l, string2, string4, string3, string5, string6);
        String string8 = HawkAuthHeaderProvider.getSignature(string7.getBytes("UTF-8"), this.key);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Hawk id=\"");
        stringBuilder.append(this.id);
        stringBuilder.append("\", ");
        stringBuilder.append("ts=\"");
        stringBuilder.append(l);
        stringBuilder.append("\", ");
        stringBuilder.append("nonce=\"");
        stringBuilder.append(string2);
        stringBuilder.append("\", ");
        if (string4 != null) {
            stringBuilder.append("hash=\"");
            stringBuilder.append(string4);
            stringBuilder.append("\", ");
        }
        if (string3 != null && string3.length() > 0) {
            stringBuilder.append("ext=\"");
            stringBuilder.append(HawkAuthHeaderProvider.escapeExtraHeaderAttribute(string3));
            stringBuilder.append("\", ");
        }
        stringBuilder.append("mac=\"");
        stringBuilder.append(string8);
        stringBuilder.append("\"");
        return new BasicHeader("Authorization", stringBuilder.toString());
    }

    protected static String getPayloadHashString(HttpRequestBase httpRequestBase) throws UnsupportedEncodingException, NoSuchAlgorithmException, IOException, IllegalArgumentException {
        boolean bl = httpRequestBase instanceof HttpEntityEnclosingRequest;
        if (!bl) {
            Logger.debug(LOG_TAG, "Not computing payload verification hash for non-enclosing request.");
            return null;
        }
        if (!(httpRequestBase instanceof HttpEntityEnclosingRequest)) {
            throw new IllegalArgumentException("Cannot compute payload verification hash for enclosing request without an entity");
        }
        HttpEntity httpEntity = ((HttpEntityEnclosingRequest)httpRequestBase).getEntity();
        if (httpEntity == null) {
            throw new IllegalArgumentException("Cannot compute payload verification hash for enclosing request with a null entity");
        }
        return Base64.encodeBase64String((byte[])HawkAuthHeaderProvider.getPayloadHash(httpEntity));
    }

    protected static String escapeExtraHeaderAttribute(String string2) {
        return string2.replaceAll("\\\\", "\\\\").replaceAll("\"", "\\\"");
    }

    protected static String escapeExtraString(String string2) {
        return string2.replaceAll("\\\\", "\\\\").replaceAll("\n", "\\n");
    }

    protected static String getBaseContentType(Header header) {
        if (header == null) {
            throw new IllegalArgumentException("contentTypeHeader must not be null.");
        }
        String string2 = header.getValue();
        if (string2 == null) {
            throw new IllegalArgumentException("contentTypeHeader value must not be null.");
        }
        int n = string2.indexOf(";");
        if (n < 0) {
            return string2.trim();
        }
        return string2.substring(0, n).trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] getPayloadHash(HttpEntity httpEntity) throws UnsupportedEncodingException, IOException, NoSuchAlgorithmException {
        if (!httpEntity.isRepeatable()) {
            throw new IllegalArgumentException("entity must be repeatable");
        }
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update("hawk.1.payload\n".getBytes("UTF-8"));
        messageDigest.update(HawkAuthHeaderProvider.getBaseContentType(httpEntity.getContentType()).getBytes("UTF-8"));
        messageDigest.update("\n".getBytes("UTF-8"));
        InputStream inputStream = httpEntity.getContent();
        try {
            int n;
            byte[] byArray = new byte[4096];
            while (-1 != (n = inputStream.read(byArray))) {
                if (n <= 0) continue;
                messageDigest.update(byArray, 0, n);
            }
            messageDigest.update("\n".getBytes("UTF-8"));
            byte[] byArray2 = messageDigest.digest();
            return byArray2;
        }
        finally {
            inputStream.close();
        }
    }

    protected static String getRequestString(HttpUriRequest httpUriRequest, String string2, long l, String string3, String string4, String string5, String string6, String string7) {
        String string8 = httpUriRequest.getMethod().toUpperCase(Locale.US);
        URI uRI = httpUriRequest.getURI();
        String string9 = uRI.getHost();
        String string10 = uRI.getRawPath();
        if (uRI.getRawQuery() != null) {
            string10 = string10 + "?";
            string10 = string10 + uRI.getRawQuery();
        }
        if (uRI.getRawFragment() != null) {
            string10 = string10 + "#";
            string10 = string10 + uRI.getRawFragment();
        }
        int n = uRI.getPort();
        String string11 = uRI.getScheme();
        if (n == -1) {
            if ("http".equalsIgnoreCase(string11)) {
                n = 80;
            } else if ("https".equalsIgnoreCase(string11)) {
                n = 443;
            } else {
                throw new IllegalArgumentException("Unsupported URI scheme: " + string11 + ".");
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("hawk.");
        stringBuilder.append(1);
        stringBuilder.append('.');
        stringBuilder.append(string2);
        stringBuilder.append('\n');
        stringBuilder.append(l);
        stringBuilder.append('\n');
        stringBuilder.append(string3);
        stringBuilder.append('\n');
        stringBuilder.append(string8);
        stringBuilder.append('\n');
        stringBuilder.append(string10);
        stringBuilder.append('\n');
        stringBuilder.append(string9);
        stringBuilder.append('\n');
        stringBuilder.append(n);
        stringBuilder.append('\n');
        if (string4 != null) {
            stringBuilder.append(string4);
        }
        stringBuilder.append("\n");
        if (string5 != null && string5.length() > 0) {
            stringBuilder.append(HawkAuthHeaderProvider.escapeExtraString(string5));
        }
        stringBuilder.append("\n");
        if (string6 != null) {
            stringBuilder.append(string6);
            stringBuilder.append("\n");
            if (string7 != null) {
                stringBuilder.append(string7);
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    protected static byte[] hmacSha256(byte[] byArray, byte[] byArray2) throws NoSuchAlgorithmException, InvalidKeyException {
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, HMAC_SHA256_ALGORITHM);
        Mac mac = Mac.getInstance(HMAC_SHA256_ALGORITHM);
        mac.init(secretKeySpec);
        mac.update(byArray);
        return mac.doFinal();
    }

    protected static String getSignature(byte[] byArray, byte[] byArray2) throws InvalidKeyException, NoSuchAlgorithmException, UnsupportedEncodingException {
        return Base64.encodeBase64String((byte[])HawkAuthHeaderProvider.hmacSha256(byArray, byArray2));
    }
}

