/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.synchronizer;

import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.repositories.domain.Record;
import org.mozilla.gecko.sync.synchronizer.RecordConsumer;
import org.mozilla.gecko.sync.synchronizer.RecordsConsumerDelegate;

class SerialRecordConsumer
extends RecordConsumer {
    private static final String LOG_TAG = "SerialRecordConsumer";
    protected boolean stopEventually = false;
    private volatile long counter = 0L;
    private Object monitor = new Object();
    private Object storeSerializer = new Object();

    public SerialRecordConsumer(RecordsConsumerDelegate recordsConsumerDelegate) {
        this.delegate = recordsConsumerDelegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doNotify() {
        Object object = this.monitor;
        synchronized (object) {
            this.monitor.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueFilled() {
        Logger.debug(LOG_TAG, "Queue filled.");
        Object object = this.monitor;
        synchronized (object) {
            this.stopEventually = true;
            this.monitor.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void halt() {
        Logger.debug(LOG_TAG, "Halting.");
        Object object = this.monitor;
        synchronized (object) {
            this.stopEventually = true;
            this.stopImmediately = true;
            this.monitor.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stored() {
        Logger.debug(LOG_TAG, "Record stored. Notifying.");
        Object object = this.storeSerializer;
        synchronized (object) {
            Logger.debug(LOG_TAG, "stored() took storeSerializer.");
            ++this.counter;
            this.storeSerializer.notify();
            Logger.debug(LOG_TAG, "stored() dropped storeSerializer.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeSerially(Record record) {
        Logger.debug(LOG_TAG, "New record to store.");
        Object object = this.storeSerializer;
        synchronized (object) {
            Logger.debug(LOG_TAG, "storeSerially() took storeSerializer.");
            Logger.debug(LOG_TAG, "Storing...");
            try {
                this.delegate.store(record);
            }
            catch (Exception exception) {
                Logger.warn(LOG_TAG, "Got exception in store. Not waiting.", exception);
                return;
            }
            try {
                Logger.debug(LOG_TAG, "Waiting...");
                this.storeSerializer.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Logger.debug(LOG_TAG, "storeSerially() dropped storeSerializer.");
        }
    }

    private void consumerIsDone() {
        long l = this.counter;
        Logger.info(LOG_TAG, "Consumer is done. Processed " + l + (l == 1L ? " record." : " records."));
        this.delegate.consumerIsDone(this.stopImmediately);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            Object object = this.monitor;
            synchronized (object) {
                Logger.debug(LOG_TAG, "run() took monitor.");
                if (this.stopImmediately) {
                    Logger.debug(LOG_TAG, "Stopping immediately. Clearing queue.");
                    this.delegate.getQueue().clear();
                    Logger.debug(LOG_TAG, "Notifying consumer.");
                    this.consumerIsDone();
                    return;
                }
                Logger.debug(LOG_TAG, "run() dropped monitor.");
            }
            while (!this.delegate.getQueue().isEmpty()) {
                Logger.debug(LOG_TAG, "Grabbing record...");
                object = (Record)this.delegate.getQueue().remove();
                Logger.debug(LOG_TAG, "Invoking storeSerially...");
                this.storeSerially((Record)object);
                Logger.debug(LOG_TAG, "Done with record.");
            }
            object = this.monitor;
            synchronized (object) {
                Logger.debug(LOG_TAG, "run() took monitor.");
                if (this.stopEventually) {
                    Logger.debug(LOG_TAG, "Done with records and told to stop. Notifying consumer.");
                    this.consumerIsDone();
                    return;
                }
                try {
                    Logger.debug(LOG_TAG, "Not told to stop but no records. Waiting.");
                    this.monitor.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Logger.debug(LOG_TAG, "run() dropped monitor.");
            }
        }
    }
}

