/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import org.mozilla.gecko.R;
import org.mozilla.gecko.animation.PropertyAnimator;
import org.mozilla.gecko.toolbar.BrowserToolbar;
import org.mozilla.gecko.toolbar.ToolbarEditText;
import org.mozilla.gecko.widget.ThemedLinearLayout;

public class ToolbarEditLayout
extends ThemedLinearLayout {
    private final ToolbarEditText mEditText;
    private View.OnFocusChangeListener mFocusChangeListener;

    public ToolbarEditLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setOrientation(0);
        LayoutInflater.from((Context)context).inflate(R.layout.toolbar_edit_layout, (ViewGroup)this);
        this.mEditText = (ToolbarEditText)this.findViewById(R.id.url_edit_text);
    }

    public void onAttachedToWindow() {
        this.mEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean bl) {
                if (ToolbarEditLayout.this.mFocusChangeListener != null) {
                    ToolbarEditLayout.this.mFocusChangeListener.onFocusChange((View)ToolbarEditLayout.this, bl);
                }
            }
        });
    }

    public void setOnFocusChangeListener(View.OnFocusChangeListener onFocusChangeListener) {
        this.mFocusChangeListener = onFocusChangeListener;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.mEditText.setEnabled(bl);
    }

    public void setPrivateMode(boolean bl) {
        super.setPrivateMode(bl);
        this.mEditText.setPrivateMode(bl);
    }

    private void showSoftInput() {
        InputMethodManager inputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
        inputMethodManager.showSoftInput((View)this.mEditText, 1);
    }

    void prepareShowAnimation(PropertyAnimator propertyAnimator) {
        if (propertyAnimator == null) {
            this.mEditText.requestFocus();
            this.showSoftInput();
            return;
        }
        propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

            public void onPropertyAnimationStart() {
                ToolbarEditLayout.this.mEditText.requestFocus();
            }

            public void onPropertyAnimationEnd() {
                ToolbarEditLayout.this.showSoftInput();
            }
        });
    }

    void setOnCommitListener(BrowserToolbar.OnCommitListener onCommitListener) {
        this.mEditText.setOnCommitListener(onCommitListener);
    }

    void setOnDismissListener(BrowserToolbar.OnDismissListener onDismissListener) {
        this.mEditText.setOnDismissListener(onDismissListener);
    }

    void setOnFilterListener(BrowserToolbar.OnFilterListener onFilterListener) {
        this.mEditText.setOnFilterListener(onFilterListener);
    }

    void onEditSuggestion(String string2) {
        this.mEditText.setText(string2);
        this.mEditText.setSelection(this.mEditText.getText().length());
        this.mEditText.requestFocus();
        this.showSoftInput();
    }

    void setText(String string2) {
        this.mEditText.setText(string2);
    }

    String getText() {
        return this.mEditText.getText().toString();
    }
}

