/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import org.mozilla.gecko.PrefsHelper;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.util.ThreadUtils;

class ToolbarTitlePrefs {
    static final String PREF_TITLEBAR_MODE = "browser.chrome.titlebarMode";
    static final String PREF_TRIM_URLS = "browser.urlbar.trimURLs";
    final String[] prefs = new String[]{"browser.chrome.titlebarMode", "browser.urlbar.trimURLs"};
    private boolean mShowUrl = false;
    private boolean mTrimUrls = true;
    private Integer mPrefObserverId = PrefsHelper.getPrefs(this.prefs, (PrefsHelper.PrefHandler)new TitlePrefsHandler());

    ToolbarTitlePrefs() {
    }

    boolean shouldShowUrl() {
        return this.mShowUrl;
    }

    boolean shouldTrimUrls() {
        return this.mTrimUrls;
    }

    void close() {
        if (this.mPrefObserverId != null) {
            PrefsHelper.removeObserver(this.mPrefObserverId);
            this.mPrefObserverId = null;
        }
    }

    private class TitlePrefsHandler
    extends PrefsHelper.PrefHandlerBase {
        private TitlePrefsHandler() {
        }

        public void prefValue(String string2, String string3) {
            boolean bl;
            int n = Integer.parseInt(string3);
            boolean bl2 = bl = n == 1;
            if (bl == ToolbarTitlePrefs.this.mShowUrl) {
                return;
            }
            ToolbarTitlePrefs.this.mShowUrl = bl;
            this.triggerChangeListener();
        }

        public void prefValue(String string2, boolean bl) {
            if (bl == ToolbarTitlePrefs.this.mTrimUrls) {
                return;
            }
            ToolbarTitlePrefs.this.mTrimUrls = bl;
            this.triggerChangeListener();
        }

        public boolean isObserver() {
            return true;
        }

        private void triggerChangeListener() {
            ThreadUtils.postToUiThread((Runnable)new Runnable(){

                public void run() {
                    Tabs tabs = Tabs.getInstance();
                    Tab tab = tabs.getSelectedTab();
                    if (tab != null) {
                        tabs.notifyListeners(tab, Tabs.TabEvents.TITLE);
                    }
                }
            });
        }
    }

    static interface OnChangeListener {
        public void onChange();
    }
}

