/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.EditText;
import org.mozilla.gecko.R;

public class FloatingHintEditText
extends EditText {
    private static final float HINT_SCALE = 0.6f;
    private static final int ANIMATION_STEPS = 6;
    private final Paint floatingHintPaint = new Paint();
    private final ColorStateList floatingHintColors;
    private final ColorStateList normalHintColors;
    private final int defaultFloatingHintColor;
    private final int defaultNormalHintColor;
    private boolean wasEmpty;
    private int animationFrame;
    private Animation animation = Animation.NONE;

    public FloatingHintEditText(Context context) {
        this(context, null);
    }

    public FloatingHintEditText(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.floatingHintEditTextStyle);
    }

    public FloatingHintEditText(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.floatingHintColors = this.getResources().getColorStateList(R.color.floating_hint_text);
        this.normalHintColors = this.getHintTextColors();
        this.defaultFloatingHintColor = this.floatingHintColors.getDefaultColor();
        this.defaultNormalHintColor = this.normalHintColors.getDefaultColor();
        this.wasEmpty = TextUtils.isEmpty((CharSequence)this.getText());
    }

    public int getCompoundPaddingTop() {
        Paint.FontMetricsInt fontMetricsInt = this.getPaint().getFontMetricsInt();
        int n = (int)((float)(fontMetricsInt.bottom - fontMetricsInt.top) * 0.6f);
        return super.getCompoundPaddingTop() + n;
    }

    protected void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        super.onTextChanged(charSequence, n, n2, n3);
        boolean bl = TextUtils.isEmpty((CharSequence)this.getText());
        if (this.wasEmpty == bl) {
            return;
        }
        this.wasEmpty = bl;
        if (!this.isShown()) {
            return;
        }
        if (bl) {
            this.animation = Animation.GROW;
            this.setHintTextColor(0);
        } else {
            this.animation = Animation.SHRINK;
        }
    }

    protected void onDraw(Canvas canvas) {
        boolean bl;
        super.onDraw(canvas);
        if (TextUtils.isEmpty((CharSequence)this.getHint())) {
            return;
        }
        boolean bl2 = bl = this.animation != Animation.NONE;
        if (!bl && TextUtils.isEmpty((CharSequence)this.getText())) {
            return;
        }
        TextPaint textPaint = this.getPaint();
        float f = this.getCompoundPaddingLeft() + this.getScrollX();
        float f2 = this.getBaseline();
        float f3 = f2 + (float)textPaint.getFontMetricsInt().top + (float)this.getScrollY();
        float f4 = this.getTextSize();
        float f5 = f4 * 0.6f;
        int[] nArray = this.getDrawableState();
        int n = this.floatingHintColors.getColorForState(nArray, this.defaultFloatingHintColor);
        this.floatingHintPaint.set((Paint)textPaint);
        if (!bl) {
            this.drawHint(canvas, f5, n, f, f3);
            return;
        }
        int n2 = this.normalHintColors.getColorForState(nArray, this.defaultNormalHintColor);
        if (this.animation == Animation.SHRINK) {
            this.drawAnimationFrame(canvas, f4, f5, f, f2, f3, n2, n);
        } else {
            this.drawAnimationFrame(canvas, f5, f4, f, f3, f2, n, n2);
        }
        ++this.animationFrame;
        if (this.animationFrame == 6) {
            if (this.animation == Animation.GROW) {
                this.setHintTextColor(this.normalHintColors);
            }
            this.animation = Animation.NONE;
            this.animationFrame = 0;
        }
        this.invalidate();
    }

    private void drawAnimationFrame(Canvas canvas, float f, float f2, float f3, float f4, float f5, int n, int n2) {
        float f6 = this.lerp(f, f2);
        float f7 = this.lerp(f4, f5);
        int n3 = Color.rgb((int)((int)this.lerp(Color.red((int)n), Color.red((int)n2))), (int)((int)this.lerp(Color.green((int)n), Color.green((int)n2))), (int)((int)this.lerp(Color.blue((int)n), Color.blue((int)n2))));
        this.drawHint(canvas, f6, n3, f3, f7);
    }

    private void drawHint(Canvas canvas, float f, int n, float f2, float f3) {
        this.floatingHintPaint.setTextSize(f);
        this.floatingHintPaint.setColor(n);
        canvas.drawText(((Object)this.getHint()).toString(), f2, f3, this.floatingHintPaint);
    }

    private float lerp(float f, float f2) {
        float f3 = (float)this.animationFrame / 5.0f;
        return f * (1.0f - f3) + f2 * f3;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Animation {
        NONE,
        SHRINK,
        GROW;

    }
}

