/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.client.protocol;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HttpException;
import ch.boye.httpclientandroidlib.HttpHost;
import ch.boye.httpclientandroidlib.HttpRequest;
import ch.boye.httpclientandroidlib.HttpRequestInterceptor;
import ch.boye.httpclientandroidlib.ProtocolException;
import ch.boye.httpclientandroidlib.androidextra.HttpClientAndroidLog;
import ch.boye.httpclientandroidlib.annotation.Immutable;
import ch.boye.httpclientandroidlib.client.CookieStore;
import ch.boye.httpclientandroidlib.client.methods.HttpUriRequest;
import ch.boye.httpclientandroidlib.client.params.HttpClientParams;
import ch.boye.httpclientandroidlib.conn.HttpRoutedConnection;
import ch.boye.httpclientandroidlib.conn.routing.HttpRoute;
import ch.boye.httpclientandroidlib.cookie.Cookie;
import ch.boye.httpclientandroidlib.cookie.CookieOrigin;
import ch.boye.httpclientandroidlib.cookie.CookieSpecRegistry;
import ch.boye.httpclientandroidlib.cookie.SetCookie2;
import ch.boye.httpclientandroidlib.protocol.HttpContext;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

@Immutable
public class RequestAddCookies
implements HttpRequestInterceptor {
    public HttpClientAndroidLog log = new HttpClientAndroidLog(this.getClass());

    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        int n;
        Object object;
        Object object2;
        Object object3;
        URI uRI;
        if (httpRequest == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (httpContext == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        String string = httpRequest.getRequestLine().getMethod();
        if (string.equalsIgnoreCase("CONNECT")) {
            return;
        }
        CookieStore cookieStore = (CookieStore)httpContext.getAttribute("http.cookie-store");
        if (cookieStore == null) {
            this.log.debug("Cookie store not specified in HTTP context");
            return;
        }
        CookieSpecRegistry cookieSpecRegistry = (CookieSpecRegistry)httpContext.getAttribute("http.cookiespec-registry");
        if (cookieSpecRegistry == null) {
            this.log.debug("CookieSpec registry not specified in HTTP context");
            return;
        }
        HttpHost httpHost = (HttpHost)httpContext.getAttribute("http.target_host");
        if (httpHost == null) {
            this.log.debug("Target host not set in the context");
            return;
        }
        HttpRoutedConnection httpRoutedConnection = (HttpRoutedConnection)httpContext.getAttribute("http.connection");
        if (httpRoutedConnection == null) {
            this.log.debug("HTTP connection not set in the context");
            return;
        }
        String string2 = HttpClientParams.getCookiePolicy(httpRequest.getParams());
        if (this.log.isDebugEnabled()) {
            this.log.debug("CookieSpec selected: " + string2);
        }
        if (httpRequest instanceof HttpUriRequest) {
            uRI = ((HttpUriRequest)httpRequest).getURI();
        } else {
            try {
                uRI = new URI(httpRequest.getRequestLine().getUri());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new ProtocolException("Invalid request URI: " + httpRequest.getRequestLine().getUri(), uRISyntaxException);
            }
        }
        String string3 = httpHost.getHostName();
        int n2 = httpHost.getPort();
        if (n2 < 0) {
            object3 = httpRoutedConnection.getRoute();
            n2 = ((HttpRoute)object3).getHopCount() == 1 ? httpRoutedConnection.getRemotePort() : (((String)(object2 = httpHost.getSchemeName())).equalsIgnoreCase("http") ? 80 : (((String)object2).equalsIgnoreCase("https") ? 443 : 0));
        }
        object3 = new CookieOrigin(string3, n2, uRI.getPath(), httpRoutedConnection.isSecure());
        object2 = cookieSpecRegistry.getCookieSpec(string2, httpRequest.getParams());
        ArrayList<Cookie> arrayList = new ArrayList<Cookie>(cookieStore.getCookies());
        ArrayList<Cookie> arrayList2 = new ArrayList<Cookie>();
        Date date = new Date();
        for (Cookie object4 : arrayList) {
            if (!object4.isExpired(date)) {
                if (!object2.match(object4, (CookieOrigin)object3)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Cookie " + object4 + " match " + object3);
                }
                arrayList2.add(object4);
                continue;
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("Cookie " + object4 + " expired");
        }
        if (!arrayList2.isEmpty()) {
            List<Header> list = object2.formatCookies(arrayList2);
            Iterator bl = list.iterator();
            while (bl.hasNext()) {
                object = (Header)bl.next();
                httpRequest.addHeader((Header)object);
            }
        }
        if ((n = object2.getVersion()) > 0) {
            boolean bl;
            boolean bl2 = false;
            object = arrayList2.iterator();
            while (object.hasNext()) {
                Cookie cookie = (Cookie)object.next();
                if (n == cookie.getVersion() && cookie instanceof SetCookie2) continue;
                bl = true;
            }
            if (bl && (object = object2.getVersionHeader()) != null) {
                httpRequest.addHeader((Header)object);
            }
        }
        httpContext.setAttribute("http.cookie-spec", object2);
        httpContext.setAttribute("http.cookie-origin", object3);
    }
}

