/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.conn.params;

import ch.boye.httpclientandroidlib.HttpHost;
import ch.boye.httpclientandroidlib.annotation.Immutable;
import ch.boye.httpclientandroidlib.conn.params.ConnRoutePNames;
import ch.boye.httpclientandroidlib.conn.routing.HttpRoute;
import ch.boye.httpclientandroidlib.params.HttpParams;
import java.net.InetAddress;

@Immutable
public class ConnRouteParams
implements ConnRoutePNames {
    public static final HttpHost NO_HOST = new HttpHost("127.0.0.255", 0, "no-host");
    public static final HttpRoute NO_ROUTE = new HttpRoute(NO_HOST);

    private ConnRouteParams() {
    }

    public static HttpHost getDefaultProxy(HttpParams httpParams) {
        if (httpParams == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        HttpHost httpHost = (HttpHost)httpParams.getParameter("http.route.default-proxy");
        if (httpHost != null && NO_HOST.equals(httpHost)) {
            httpHost = null;
        }
        return httpHost;
    }

    public static void setDefaultProxy(HttpParams httpParams, HttpHost httpHost) {
        if (httpParams == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        httpParams.setParameter("http.route.default-proxy", httpHost);
    }

    public static HttpRoute getForcedRoute(HttpParams httpParams) {
        if (httpParams == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        HttpRoute httpRoute = (HttpRoute)httpParams.getParameter("http.route.forced-route");
        if (httpRoute != null && NO_ROUTE.equals(httpRoute)) {
            httpRoute = null;
        }
        return httpRoute;
    }

    public static void setForcedRoute(HttpParams httpParams, HttpRoute httpRoute) {
        if (httpParams == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        httpParams.setParameter("http.route.forced-route", httpRoute);
    }

    public static InetAddress getLocalAddress(HttpParams httpParams) {
        if (httpParams == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        InetAddress inetAddress = (InetAddress)httpParams.getParameter("http.route.local-address");
        return inetAddress;
    }

    public static void setLocalAddress(HttpParams httpParams, InetAddress inetAddress) {
        if (httpParams == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        httpParams.setParameter("http.route.local-address", inetAddress);
    }
}

