/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import android.os.Bundle;
import android.util.Log;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public final class JSONUtils {
    private static final String LOGTAG = "GeckoJSONUtils";

    private JSONUtils() {
    }

    public static UUID getUUID(String string, JSONObject jSONObject) {
        String string2 = jSONObject.optString(string, null);
        return string2 != null ? UUID.fromString(string2) : null;
    }

    public static void putUUID(String string, UUID uUID, JSONObject jSONObject) {
        String string2 = uUID.toString();
        try {
            jSONObject.put(string, (Object)string2);
        }
        catch (JSONException jSONException) {
            throw new IllegalArgumentException(string + "=" + string2, jSONException);
        }
    }

    public static JSONObject bundleToJSON(Bundle bundle) {
        if (bundle == null || bundle.isEmpty()) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        for (String string : bundle.keySet()) {
            try {
                jSONObject.put(string, bundle.get(string));
            }
            catch (JSONException jSONException) {
                Log.w((String)LOGTAG, (String)"Error building JSON response.", (Throwable)jSONException);
            }
        }
        return jSONObject;
    }
}

