/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public final class WebActivityMapper {
    private static final Map<String, WebActivityMapping> activityMap = new HashMap<String, WebActivityMapping>();

    public static Intent getIntentForWebActivity(JSONObject jSONObject) throws JSONException {
        String string;
        String string2 = jSONObject.getString("name").toLowerCase();
        JSONObject jSONObject2 = jSONObject.getJSONObject("data");
        WebActivityMapping webActivityMapping = activityMap.get(string2);
        Intent intent = new Intent(webActivityMapping.getAction());
        String string3 = webActivityMapping.getMime(jSONObject2);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            intent.setType(string3);
        }
        if (!TextUtils.isEmpty((CharSequence)(string = webActivityMapping.getUri(jSONObject2)))) {
            intent.setData(Uri.parse((String)string));
        }
        webActivityMapping.putExtras(jSONObject2, intent);
        return intent;
    }

    private static void optPutExtra(String string, String string2, JSONObject jSONObject, Intent intent) {
        String string3 = jSONObject.optString(string);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            intent.putExtra(string2, string3);
        }
    }

    static {
        activityMap.put("dial", new DialMapping());
        activityMap.put("open", new OpenMapping());
        activityMap.put("pick", new PickMapping());
        activityMap.put("send", new SendMapping());
        activityMap.put("view", new ViewMapping());
    }

    private static class ViewMapping
    extends BaseMapping {
        private ViewMapping() {
        }

        public String getAction() {
            return "android.intent.action.VIEW";
        }

        public String getMime(JSONObject jSONObject) {
            String string = jSONObject.optString("type", null);
            if ("url".equals(string) || "uri".equals(string)) {
                return null;
            }
            return string;
        }
    }

    private static class SendMapping
    extends BaseMapping {
        private SendMapping() {
        }

        public String getAction() {
            return "android.intent.action.SEND";
        }

        public void putExtras(JSONObject jSONObject, Intent intent) throws JSONException {
            WebActivityMapper.optPutExtra("text", "android.intent.extra.TEXT", jSONObject, intent);
            WebActivityMapper.optPutExtra("html_text", "android.intent.extra.HTML_TEXT", jSONObject, intent);
            WebActivityMapper.optPutExtra("stream", "android.intent.extra.STREAM", jSONObject, intent);
        }
    }

    private static class PickMapping
    extends BaseMapping {
        private PickMapping() {
        }

        public String getAction() {
            return "android.intent.action.GET_CONTENT";
        }
    }

    private static class OpenMapping
    extends BaseMapping {
        private OpenMapping() {
        }

        public String getAction() {
            return "android.intent.action.VIEW";
        }
    }

    private static class DialMapping
    extends WebActivityMapping {
        private DialMapping() {
        }

        public String getAction() {
            return "android.intent.action.DIAL";
        }

        public String getUri(JSONObject jSONObject) throws JSONException {
            return "tel:" + jSONObject.getString("number");
        }
    }

    private static abstract class BaseMapping
    extends WebActivityMapping {
        private BaseMapping() {
        }

        public String getMime(JSONObject jSONObject) throws JSONException {
            return jSONObject.optString("type", null);
        }

        public String getUri(JSONObject jSONObject) throws JSONException {
            String string = jSONObject.optString("uri", null);
            return string != null ? string : jSONObject.optString("url", null);
        }
    }

    private static abstract class WebActivityMapping {
        private WebActivityMapping() {
        }

        public abstract String getAction();

        public String getMime(JSONObject jSONObject) throws JSONException {
            return null;
        }

        public String getUri(JSONObject jSONObject) throws JSONException {
            return null;
        }

        public void putExtras(JSONObject jSONObject, Intent intent) throws JSONException {
        }
    }
}

