/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.Context;
import android.net.Uri;
import android.net.http.HttpResponseCache;
import android.os.Build;
import com.squareup.picasso.Downloader;
import com.squareup.picasso.Utils;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

public class UrlConnectionDownloader
implements Downloader {
    static final String RESPONSE_SOURCE = "X-Android-Response-Source";
    private static final Object lock = new Object();
    static volatile Object cache;
    private final Context context;

    public UrlConnectionDownloader(Context context) {
        this.context = context.getApplicationContext();
    }

    protected HttpURLConnection openConnection(Uri uri) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(uri.toString()).openConnection();
        httpURLConnection.setConnectTimeout(15000);
        httpURLConnection.setReadTimeout(20000);
        return httpURLConnection;
    }

    public Downloader.Response load(Uri uri, boolean bl) throws IOException {
        int n;
        if (Build.VERSION.SDK_INT >= 14) {
            UrlConnectionDownloader.installCacheIfNeeded(this.context);
        }
        HttpURLConnection httpURLConnection = this.openConnection(uri);
        httpURLConnection.setUseCaches(true);
        if (bl) {
            httpURLConnection.setRequestProperty("Cache-Control", "only-if-cached,max-age=2147483647");
        }
        if ((n = httpURLConnection.getResponseCode()) >= 300) {
            httpURLConnection.disconnect();
            throw new Downloader.ResponseException(n + " " + httpURLConnection.getResponseMessage());
        }
        boolean bl2 = Utils.parseResponseSourceHeader(httpURLConnection.getHeaderField(RESPONSE_SOURCE));
        return new Downloader.Response(httpURLConnection.getInputStream(), bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void installCacheIfNeeded(Context context) {
        if (cache == null) {
            try {
                Object object = lock;
                synchronized (object) {
                    if (cache == null) {
                        cache = ResponseCacheIcs.install(context);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class ResponseCacheIcs {
        private ResponseCacheIcs() {
        }

        static Object install(Context context) throws IOException {
            File file = Utils.createDefaultCacheDir(context);
            HttpResponseCache httpResponseCache = HttpResponseCache.getInstalled();
            if (httpResponseCache == null) {
                long l = Utils.calculateDiskCacheSize(file);
                httpResponseCache = HttpResponseCache.install((File)file, (long)l);
            }
            return httpResponseCache;
        }
    }
}

