/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.widget.ImageView;
import com.squareup.picasso.Action;
import com.squareup.picasso.BitmapHunter;
import com.squareup.picasso.Cache;
import com.squareup.picasso.DeferredRequestCreator;
import com.squareup.picasso.Dispatcher;
import com.squareup.picasso.Downloader;
import com.squareup.picasso.LruCache;
import com.squareup.picasso.PicassoExecutorService;
import com.squareup.picasso.Request;
import com.squareup.picasso.RequestCreator;
import com.squareup.picasso.Stats;
import com.squareup.picasso.StatsSnapshot;
import com.squareup.picasso.Target;
import com.squareup.picasso.Utils;
import java.io.File;
import java.lang.ref.ReferenceQueue;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;

public class Picasso {
    static final Handler HANDLER = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message message) {
            switch (message.what) {
                case 8: {
                    List list = (List)message.obj;
                    for (BitmapHunter bitmapHunter : list) {
                        bitmapHunter.picasso.complete(bitmapHunter);
                    }
                    break;
                }
                case 3: {
                    Action action = (Action)message.obj;
                    action.picasso.cancelExistingRequest(action.getTarget());
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown handler message received: " + message.what));
                }
            }
        }
    };
    static Picasso singleton = null;
    private final Listener listener;
    private final RequestTransformer requestTransformer;
    private final CleanupThread cleanupThread;
    final Context context;
    final Dispatcher dispatcher;
    final Cache cache;
    final Stats stats;
    final Map<Object, Action> targetToAction;
    final Map<ImageView, DeferredRequestCreator> targetToDeferredRequestCreator;
    final ReferenceQueue<Object> referenceQueue;
    boolean debugging;
    boolean shutdown;

    Picasso(Context context, Dispatcher dispatcher, Cache cache, Listener listener, RequestTransformer requestTransformer, Stats stats, boolean bl) {
        this.context = context;
        this.dispatcher = dispatcher;
        this.cache = cache;
        this.listener = listener;
        this.requestTransformer = requestTransformer;
        this.stats = stats;
        this.targetToAction = new WeakHashMap<Object, Action>();
        this.targetToDeferredRequestCreator = new WeakHashMap<ImageView, DeferredRequestCreator>();
        this.debugging = bl;
        this.referenceQueue = new ReferenceQueue();
        this.cleanupThread = new CleanupThread(this.referenceQueue, HANDLER);
        this.cleanupThread.start();
    }

    public void cancelRequest(ImageView imageView) {
        this.cancelExistingRequest(imageView);
    }

    public void cancelRequest(Target target) {
        this.cancelExistingRequest(target);
    }

    public RequestCreator load(Uri uri) {
        return new RequestCreator(this, uri, 0);
    }

    public RequestCreator load(String string) {
        if (string == null) {
            return new RequestCreator(this, null, 0);
        }
        if (string.trim().length() == 0) {
            throw new IllegalArgumentException("Path must not be empty.");
        }
        return this.load(Uri.parse((String)string));
    }

    public RequestCreator load(File file) {
        if (file == null) {
            return new RequestCreator(this, null, 0);
        }
        return this.load(Uri.fromFile((File)file));
    }

    public RequestCreator load(int n) {
        if (n == 0) {
            throw new IllegalArgumentException("Resource ID must not be zero.");
        }
        return new RequestCreator(this, null, n);
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public void setDebugging(boolean bl) {
        this.debugging = bl;
    }

    public StatsSnapshot getSnapshot() {
        return this.stats.createSnapshot();
    }

    public void shutdown() {
        if (this == singleton) {
            throw new UnsupportedOperationException("Default singleton instance cannot be shutdown.");
        }
        if (this.shutdown) {
            return;
        }
        this.cache.clear();
        this.cleanupThread.shutdown();
        this.stats.shutdown();
        this.dispatcher.shutdown();
        for (DeferredRequestCreator deferredRequestCreator : this.targetToDeferredRequestCreator.values()) {
            deferredRequestCreator.cancel();
        }
        this.targetToDeferredRequestCreator.clear();
        this.shutdown = true;
    }

    Request transformRequest(Request request) {
        Request request2 = this.requestTransformer.transformRequest(request);
        if (request2 == null) {
            throw new IllegalStateException("Request transformer " + this.requestTransformer.getClass().getCanonicalName() + " returned null for " + request);
        }
        return request2;
    }

    void defer(ImageView imageView, DeferredRequestCreator deferredRequestCreator) {
        this.targetToDeferredRequestCreator.put(imageView, deferredRequestCreator);
    }

    void enqueueAndSubmit(Action action) {
        Object t = action.getTarget();
        if (t != null) {
            this.cancelExistingRequest(t);
            this.targetToAction.put(t, action);
        }
        this.submit(action);
    }

    void submit(Action action) {
        this.dispatcher.dispatchSubmit(action);
    }

    Bitmap quickMemoryCacheCheck(String string) {
        Bitmap bitmap = this.cache.get(string);
        if (bitmap != null) {
            this.stats.dispatchCacheHit();
        } else {
            this.stats.dispatchCacheMiss();
        }
        return bitmap;
    }

    void complete(BitmapHunter bitmapHunter) {
        List<Action> list = bitmapHunter.getActions();
        if (list.isEmpty()) {
            return;
        }
        Uri uri = bitmapHunter.getData().uri;
        Exception exception = bitmapHunter.getException();
        Bitmap bitmap = bitmapHunter.getResult();
        LoadedFrom loadedFrom = bitmapHunter.getLoadedFrom();
        for (Action action : list) {
            if (action.isCancelled()) continue;
            this.targetToAction.remove(action.getTarget());
            if (bitmap != null) {
                if (loadedFrom == null) {
                    throw new AssertionError((Object)"LoadedFrom cannot be null.");
                }
                action.complete(bitmap, loadedFrom);
                continue;
            }
            action.error();
        }
        if (this.listener != null && exception != null) {
            this.listener.onImageLoadFailed(this, uri, exception);
        }
    }

    private void cancelExistingRequest(Object object) {
        ImageView imageView;
        DeferredRequestCreator deferredRequestCreator;
        Action action = this.targetToAction.remove(object);
        if (action != null) {
            action.cancel();
            this.dispatcher.dispatchCancel(action);
        }
        if (object instanceof ImageView && (deferredRequestCreator = this.targetToDeferredRequestCreator.remove(imageView = (ImageView)object)) != null) {
            deferredRequestCreator.cancel();
        }
    }

    public static Picasso with(Context context) {
        if (singleton == null) {
            singleton = new Builder(context).build();
        }
        return singleton;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LoadedFrom {
        MEMORY(-16711936),
        DISK(-256),
        NETWORK(-65536);

        final int debugColor;

        private LoadedFrom(int n2) {
            this.debugColor = n2;
        }
    }

    public static class Builder {
        private final Context context;
        private Downloader downloader;
        private ExecutorService service;
        private Cache cache;
        private Listener listener;
        private RequestTransformer transformer;
        private boolean debugging;

        public Builder(Context context) {
            if (context == null) {
                throw new IllegalArgumentException("Context must not be null.");
            }
            this.context = context.getApplicationContext();
        }

        public Builder downloader(Downloader downloader) {
            if (downloader == null) {
                throw new IllegalArgumentException("Downloader must not be null.");
            }
            if (this.downloader != null) {
                throw new IllegalStateException("Downloader already set.");
            }
            this.downloader = downloader;
            return this;
        }

        public Builder executor(ExecutorService executorService) {
            if (executorService == null) {
                throw new IllegalArgumentException("Executor service must not be null.");
            }
            if (this.service != null) {
                throw new IllegalStateException("Executor service already set.");
            }
            this.service = executorService;
            return this;
        }

        public Builder memoryCache(Cache cache) {
            if (cache == null) {
                throw new IllegalArgumentException("Memory cache must not be null.");
            }
            if (this.cache != null) {
                throw new IllegalStateException("Memory cache already set.");
            }
            this.cache = cache;
            return this;
        }

        public Builder listener(Listener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("Listener must not be null.");
            }
            if (this.listener != null) {
                throw new IllegalStateException("Listener already set.");
            }
            this.listener = listener;
            return this;
        }

        public Builder requestTransformer(RequestTransformer requestTransformer) {
            if (requestTransformer == null) {
                throw new IllegalArgumentException("Transformer must not be null.");
            }
            if (this.transformer != null) {
                throw new IllegalStateException("Transformer already set.");
            }
            this.transformer = requestTransformer;
            return this;
        }

        public Builder debugging(boolean bl) {
            this.debugging = bl;
            return this;
        }

        public Picasso build() {
            Context context = this.context;
            if (this.downloader == null) {
                this.downloader = Utils.createDefaultDownloader(context);
            }
            if (this.cache == null) {
                this.cache = new LruCache(context);
            }
            if (this.service == null) {
                this.service = new PicassoExecutorService();
            }
            if (this.transformer == null) {
                this.transformer = RequestTransformer.IDENTITY;
            }
            Stats stats = new Stats(this.cache);
            Dispatcher dispatcher = new Dispatcher(context, this.service, HANDLER, this.downloader, this.cache, stats);
            return new Picasso(context, dispatcher, this.cache, this.listener, this.transformer, stats, this.debugging);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CleanupThread
    extends Thread {
        private final ReferenceQueue<?> referenceQueue;
        private final Handler handler;

        CleanupThread(ReferenceQueue<?> referenceQueue, Handler handler) {
            this.referenceQueue = referenceQueue;
            this.handler = handler;
            this.setDaemon(true);
            this.setName("Picasso-refQueue");
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)10);
            try {
                while (true) {
                    Action.RequestWeakReference requestWeakReference = (Action.RequestWeakReference)this.referenceQueue.remove();
                    this.handler.sendMessage(this.handler.obtainMessage(3, (Object)requestWeakReference.action));
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                this.handler.post(new Runnable(){

                    public void run() {
                        throw new RuntimeException(exception);
                    }
                });
            }
        }

        void shutdown() {
            this.interrupt();
        }
    }

    public static interface RequestTransformer {
        public static final RequestTransformer IDENTITY = new RequestTransformer(){

            public Request transformRequest(Request request) {
                return request;
            }
        };

        public Request transformRequest(Request var1);
    }

    public static interface Listener {
        public void onImageLoadFailed(Picasso var1, Uri var2, Exception var3);
    }
}

