/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Looper;
import android.os.Process;
import android.os.StatFs;
import android.provider.Settings;
import com.squareup.picasso.Downloader;
import com.squareup.picasso.Request;
import com.squareup.picasso.UrlConnectionDownloader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.ThreadFactory;

final class Utils {
    static final String THREAD_PREFIX = "Picasso-";
    static final String THREAD_IDLE_NAME = "Picasso-Idle";
    static final int DEFAULT_READ_TIMEOUT = 20000;
    static final int DEFAULT_CONNECT_TIMEOUT = 15000;
    private static final String PICASSO_CACHE = "picasso-cache";
    private static final int KEY_PADDING = 50;
    private static final int MIN_DISK_CACHE_SIZE = 0x500000;
    private static final int MAX_DISK_CACHE_SIZE = 0x3200000;
    private static final int WEBP_FILE_HEADER_SIZE = 12;
    private static final String WEBP_FILE_HEADER_RIFF = "RIFF";
    private static final String WEBP_FILE_HEADER_WEBP = "WEBP";

    private Utils() {
    }

    static int getBitmapBytes(Bitmap bitmap) {
        int n = Build.VERSION.SDK_INT >= 12 ? BitmapHoneycombMR1.getByteCount(bitmap) : bitmap.getRowBytes() * bitmap.getHeight();
        if (n < 0) {
            throw new IllegalStateException("Negative size: " + bitmap);
        }
        return n;
    }

    static void checkNotMain() {
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            throw new IllegalStateException("Method call should not happen from the main thread.");
        }
    }

    static String createKey(Request request) {
        StringBuilder stringBuilder;
        if (request.uri != null) {
            String string = request.uri.toString();
            stringBuilder = new StringBuilder(string.length() + 50);
            stringBuilder.append(string);
        } else {
            stringBuilder = new StringBuilder(50);
            stringBuilder.append(request.resourceId);
        }
        stringBuilder.append('\n');
        if (request.rotationDegrees != 0.0f) {
            stringBuilder.append("rotation:").append(request.rotationDegrees);
            if (request.hasRotationPivot) {
                stringBuilder.append('@').append(request.rotationPivotX).append('x').append(request.rotationPivotY);
            }
            stringBuilder.append('\n');
        }
        if (request.targetWidth != 0) {
            stringBuilder.append("resize:").append(request.targetWidth).append('x').append(request.targetHeight);
            stringBuilder.append('\n');
        }
        if (request.centerCrop) {
            stringBuilder.append("centerCrop\n");
        } else if (request.centerInside) {
            stringBuilder.append("centerInside\n");
        }
        if (request.transformations != null) {
            int n = request.transformations.size();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(request.transformations.get(i).key());
                stringBuilder.append('\n');
            }
        }
        return stringBuilder.toString();
    }

    static void closeQuietly(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static boolean parseResponseSourceHeader(String string) {
        if (string == null) {
            return false;
        }
        String[] stringArray = string.split(" ", 2);
        if ("CACHE".equals(stringArray[0])) {
            return true;
        }
        if (stringArray.length == 1) {
            return false;
        }
        try {
            return "CONDITIONAL_CACHE".equals(stringArray[0]) && Integer.parseInt(stringArray[1]) == 304;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    static Downloader createDefaultDownloader(Context context) {
        return new UrlConnectionDownloader(context);
    }

    static File createDefaultCacheDir(Context context) {
        File file = new File(context.getApplicationContext().getCacheDir(), PICASSO_CACHE);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    static long calculateDiskCacheSize(File file) {
        long l = 0x500000L;
        try {
            StatFs statFs = new StatFs(file.getAbsolutePath());
            long l2 = (long)statFs.getBlockCount() * (long)statFs.getBlockSize();
            l = l2 / 50L;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return Math.max(Math.min(l, 0x3200000L), 0x500000L);
    }

    static int calculateMemoryCacheSize(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        boolean bl = (context.getApplicationInfo().flags & 0x100000) != 0;
        int n = activityManager.getMemoryClass();
        if (bl && Build.VERSION.SDK_INT >= 11) {
            n = ActivityManagerHoneycomb.getLargeMemoryClass(activityManager);
        }
        return 0x100000 * n / 7;
    }

    static boolean isAirplaneModeOn(Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        return Settings.System.getInt((ContentResolver)contentResolver, (String)"airplane_mode_on", (int)0) != 0;
    }

    static boolean hasPermission(Context context, String string) {
        return context.checkCallingOrSelfPermission(string) == 0;
    }

    static byte[] toByteArray(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        int n = 0;
        while (-1 != (n = inputStream.read(byArray))) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    static boolean isWebPFile(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[12];
        boolean bl = false;
        if (inputStream.read(byArray, 0, 12) == 12) {
            bl = WEBP_FILE_HEADER_RIFF.equals(new String(byArray, 0, 4, "US-ASCII")) && WEBP_FILE_HEADER_WEBP.equals(new String(byArray, 8, 4, "US-ASCII"));
        }
        return bl;
    }

    static int getResourceId(Resources resources, Request request) throws FileNotFoundException {
        int n;
        if (request.resourceId != 0 || request.uri == null) {
            return request.resourceId;
        }
        String string = request.uri.getAuthority();
        if (string == null) {
            throw new FileNotFoundException("No package provided: " + request.uri);
        }
        List list = request.uri.getPathSegments();
        if (list == null || list.isEmpty()) {
            throw new FileNotFoundException("No path segments: " + request.uri);
        }
        if (list.size() == 1) {
            try {
                n = Integer.parseInt((String)list.get(0));
            }
            catch (NumberFormatException numberFormatException) {
                throw new FileNotFoundException("Last path segment is not a resource ID: " + request.uri);
            }
        } else if (list.size() == 2) {
            String string2 = (String)list.get(0);
            String string3 = (String)list.get(1);
            n = resources.getIdentifier(string3, string2, string);
        } else {
            throw new FileNotFoundException("More than two path segments: " + request.uri);
        }
        return n;
    }

    static Resources getResources(Context context, Request request) throws FileNotFoundException {
        if (request.resourceId != 0 || request.uri == null) {
            return context.getResources();
        }
        String string = request.uri.getAuthority();
        if (string == null) {
            throw new FileNotFoundException("No package provided: " + request.uri);
        }
        try {
            PackageManager packageManager = context.getPackageManager();
            return packageManager.getResourcesForApplication(string);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new FileNotFoundException("Unable to obtain resources for package: " + request.uri);
        }
    }

    @TargetApi(value=12)
    private static class BitmapHoneycombMR1 {
        private BitmapHoneycombMR1() {
        }

        static int getByteCount(Bitmap bitmap) {
            return bitmap.getByteCount();
        }
    }

    private static class PicassoThread
    extends Thread {
        public PicassoThread(Runnable runnable) {
            super(runnable);
        }

        public void run() {
            Process.setThreadPriority((int)10);
            super.run();
        }
    }

    static class PicassoThreadFactory
    implements ThreadFactory {
        PicassoThreadFactory() {
        }

        public Thread newThread(Runnable runnable) {
            return new PicassoThread(runnable);
        }
    }

    @TargetApi(value=11)
    private static class ActivityManagerHoneycomb {
        private ActivityManagerHoneycomb() {
        }

        static int getLargeMemoryClass(ActivityManager activityManager) {
            return activityManager.getLargeMemoryClass();
        }
    }
}

