/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.util;

import java.io.UnsupportedEncodingException;

public final class EncodingUtils {
    public static String getString(byte[] byArray, int n, int n2, String string) {
        if (byArray == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("charset may not be null or empty");
        }
        try {
            return new String(byArray, n, n2, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray, n, n2);
        }
    }

    public static String getString(byte[] byArray, String string) {
        if (byArray == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        return EncodingUtils.getString(byArray, 0, byArray.length, string);
    }

    public static byte[] getBytes(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("data may not be null");
        }
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("charset may not be null or empty");
        }
        try {
            return string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string.getBytes();
        }
    }

    public static byte[] getAsciiBytes(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        try {
            return string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Error("HttpClient requires ASCII support");
        }
    }

    public static String getAsciiString(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        try {
            return new String(byArray, n, n2, "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Error("HttpClient requires ASCII support");
        }
    }

    public static String getAsciiString(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        return EncodingUtils.getAsciiString(byArray, 0, byArray.length);
    }

    private EncodingUtils() {
    }
}

