/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.StrictMode;
import android.preference.PreferenceManager;
import android.util.Log;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.mozglue.RobocopTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RobocopTarget
public final class GeckoSharedPrefs {
    private static final String LOGTAG = "GeckoSharedPrefs";
    public static final int PREFS_VERSION = 1;
    public static final String APP_PREFS_NAME = "GeckoApp";
    public static final String PROFILE_PREFS_NAME_PREFIX = "GeckoProfile-";
    private static final String PREFS_VERSION_KEY = "gecko_shared_prefs_migration";
    private static final EnumSet<Flags> disableMigrations = EnumSet.of(Flags.DISABLE_MIGRATIONS);
    private static final String[] PROFILE_MIGRATIONS_0_TO_1 = new String[]{"home_panels", "home_locale"};
    private static volatile boolean migrationDone = false;

    public static SharedPreferences forApp(Context context) {
        return GeckoSharedPrefs.forApp(context, EnumSet.noneOf(Flags.class));
    }

    public static SharedPreferences forApp(Context context, EnumSet<Flags> enumSet) {
        if (enumSet != null && !enumSet.contains((Object)Flags.DISABLE_MIGRATIONS)) {
            GeckoSharedPrefs.migrateIfNecessary(context);
        }
        return context.getSharedPreferences(APP_PREFS_NAME, 0);
    }

    public static SharedPreferences forProfile(Context context) {
        return GeckoSharedPrefs.forProfile(context, EnumSet.noneOf(Flags.class));
    }

    public static SharedPreferences forProfile(Context context, EnumSet<Flags> enumSet) {
        String string = GeckoProfile.get(context).getName();
        if (string == null) {
            throw new IllegalStateException("Could not get current profile name");
        }
        return GeckoSharedPrefs.forProfileName(context, string, enumSet);
    }

    public static SharedPreferences forProfileName(Context context, String string) {
        return GeckoSharedPrefs.forProfileName(context, string, EnumSet.noneOf(Flags.class));
    }

    public static SharedPreferences forProfileName(Context context, String string, EnumSet<Flags> enumSet) {
        if (enumSet != null && !enumSet.contains((Object)Flags.DISABLE_MIGRATIONS)) {
            GeckoSharedPrefs.migrateIfNecessary(context);
        }
        String string2 = PROFILE_PREFS_NAME_PREFIX + string;
        return context.getSharedPreferences(string2, 0);
    }

    public static int getVersion(Context context) {
        return GeckoSharedPrefs.forApp(context, disableMigrations).getInt(PREFS_VERSION_KEY, 0);
    }

    public static synchronized void reset() {
        migrationDone = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void migrateIfNecessary(Context context) {
        if (migrationDone) {
            return;
        }
        if (Build.VERSION.SDK_INT < 9) {
            GeckoSharedPrefs.performMigration(context);
        } else {
            StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
            StrictMode.allowThreadDiskWrites();
            try {
                GeckoSharedPrefs.performMigration(context);
            }
            finally {
                StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
            }
        }
        migrationDone = true;
    }

    private static void performMigration(Context context) {
        String string;
        SharedPreferences sharedPreferences = GeckoSharedPrefs.forApp(context, disableMigrations);
        int n = sharedPreferences.getInt(PREFS_VERSION_KEY, 0);
        Log.d((String)LOGTAG, (String)("Current version = " + n + ", prefs version = " + 1));
        if (n == 1) {
            return;
        }
        Log.d((String)LOGTAG, (String)"Performing migration");
        SharedPreferences.Editor editor = sharedPreferences.edit();
        try {
            string = GeckoProfile.getDefaultProfileName(context);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Failed to get default profile name for migration");
        }
        SharedPreferences.Editor editor2 = GeckoSharedPrefs.forProfileName(context, string, disableMigrations).edit();
        SharedPreferences.Editor editor3 = null;
        for (int i = n + 1; i <= 1; ++i) {
            Log.d((String)LOGTAG, (String)("Migrating to version = " + i));
            switch (i) {
                case 1: {
                    List<String> list = Arrays.asList(PROFILE_MIGRATIONS_0_TO_1);
                    editor3 = GeckoSharedPrefs.migrateFromPreferenceManager(context, editor, editor2, list);
                }
            }
        }
        editor.putInt(PREFS_VERSION_KEY, 1);
        editor.commit();
        editor2.commit();
        if (editor3 != null) {
            editor3.commit();
        }
        Log.d((String)LOGTAG, (String)"All keys have been migrated");
    }

    public static SharedPreferences.Editor migrateFromPreferenceManager(Context context, SharedPreferences.Editor editor, SharedPreferences.Editor editor2, List<String> list) {
        Log.d((String)LOGTAG, (String)"Migrating from PreferenceManager");
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        for (Map.Entry entry : sharedPreferences.getAll().entrySet()) {
            String string = (String)entry.getKey();
            SharedPreferences.Editor editor3 = list.contains(string) ? editor2 : editor;
            GeckoSharedPrefs.putEntry(editor3, string, entry.getValue());
        }
        return sharedPreferences.edit().clear();
    }

    private static void putEntry(SharedPreferences.Editor editor, String string, Object object) {
        Log.d((String)LOGTAG, (String)("Migrating key = " + string + " with value = " + object));
        if (object instanceof String) {
            editor.putString(string, (String)object);
        } else if (object instanceof Boolean) {
            editor.putBoolean(string, ((Boolean)object).booleanValue());
        } else if (object instanceof Long) {
            editor.putLong(string, ((Long)object).longValue());
        } else if (object instanceof Float) {
            editor.putFloat(string, ((Float)object).floatValue());
        } else if (object instanceof Integer) {
            editor.putInt(string, ((Integer)object).intValue());
        } else {
            throw new IllegalStateException("Unrecognized value type for key: " + string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Flags {
        DISABLE_MIGRATIONS;

    }
}

