/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.util.Log;
import java.util.ArrayList;
import org.mozilla.gecko.Envelope;

class Postman {
    public static final int kUnknownEnvelopeId = -1;
    private static final Postman sInstance = new Postman();
    private ArrayList<Envelope> mEnvelopes = new ArrayList(1);

    private Postman() {
    }

    public static Postman getInstance() {
        return sInstance;
    }

    public int createEnvelope(int n) {
        int n2 = this.mEnvelopes.size();
        for (int i = 0; i < n2; ++i) {
            if (this.mEnvelopes.get(i) != null) continue;
            this.mEnvelopes.set(i, new Envelope(i, n));
            return i;
        }
        this.mEnvelopes.add(new Envelope(n2, n));
        return n2;
    }

    public Envelope getEnvelope(int n) {
        if (n < 0 || this.mEnvelopes.size() <= n) {
            Log.e((String)"GeckoSmsManager", (String)"Trying to get an unknown Envelope!");
            return null;
        }
        Envelope envelope = this.mEnvelopes.get(n);
        if (envelope == null) {
            Log.e((String)"GeckoSmsManager", (String)"Trying to get an empty Envelope!");
        }
        return envelope;
    }

    public void destroyEnvelope(int n) {
        if (n < 0 || this.mEnvelopes.size() <= n) {
            Log.e((String)"GeckoSmsManager", (String)"Trying to destroy an unknown Envelope!");
            return;
        }
        if (this.mEnvelopes.set(n, null) == null) {
            Log.e((String)"GeckoSmsManager", (String)"Trying to destroy an empty Envelope!");
        }
    }
}

