/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.fxa;

import ch.boye.httpclientandroidlib.HttpResponse;
import org.mozilla.gecko.R;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.HTTPFailureException;
import org.mozilla.gecko.sync.net.SyncStorageResponse;

public class FxAccountClientException
extends Exception {
    private static final long serialVersionUID = 7953459541558266597L;

    public FxAccountClientException(String string2) {
        super(string2);
    }

    public FxAccountClientException(Exception exception) {
        super(exception);
    }

    public static class FxAccountClientMalformedResponseException
    extends FxAccountClientRemoteException {
        private static final long serialVersionUID = 2209313149952001098L;

        public FxAccountClientMalformedResponseException(HttpResponse httpResponse) {
            super(httpResponse, 0L, 999L, "Response malformed", "Response malformed", "Response malformed", new ExtendedJSONObject());
        }
    }

    public static class FxAccountClientRemoteException
    extends FxAccountClientException {
        private static final long serialVersionUID = 2209313149952001097L;
        public final HttpResponse response;
        public final long httpStatusCode;
        public final long apiErrorNumber;
        public final String error;
        public final String message;
        public final String info;
        public final ExtendedJSONObject body;

        public FxAccountClientRemoteException(HttpResponse httpResponse, long l, long l2, String string2, String string3, String string4, ExtendedJSONObject extendedJSONObject) {
            super(new HTTPFailureException(new SyncStorageResponse(httpResponse)));
            if (extendedJSONObject == null) {
                throw new IllegalArgumentException("body must not be null");
            }
            this.response = httpResponse;
            this.httpStatusCode = l;
            this.apiErrorNumber = l2;
            this.error = string2;
            this.message = string3;
            this.info = string4;
            this.body = extendedJSONObject;
        }

        public String toString() {
            return "<FxAccountClientRemoteException " + this.httpStatusCode + " [" + this.apiErrorNumber + "]: " + this.message + ">";
        }

        public boolean isInvalidAuthentication() {
            return this.httpStatusCode == 401L;
        }

        public boolean isAccountAlreadyExists() {
            return this.apiErrorNumber == 101L;
        }

        public boolean isAccountDoesNotExist() {
            return this.apiErrorNumber == 102L;
        }

        public boolean isBadPassword() {
            return this.apiErrorNumber == 103L;
        }

        public boolean isUnverified() {
            return this.apiErrorNumber == 104L;
        }

        public boolean isUpgradeRequired() {
            return this.apiErrorNumber == 116L || this.apiErrorNumber == 117L || this.apiErrorNumber == 118L || this.apiErrorNumber == 119L;
        }

        public boolean isTooManyRequests() {
            return this.apiErrorNumber == 114L;
        }

        public boolean isServerUnavailable() {
            return this.apiErrorNumber == 201L;
        }

        public boolean isBadEmailCase() {
            return this.apiErrorNumber == 120L;
        }

        public int getErrorMessageStringResource() {
            if (this.isUpgradeRequired()) {
                return R.string.fxaccount_remote_error_UPGRADE_REQUIRED;
            }
            if (this.isAccountAlreadyExists()) {
                return R.string.fxaccount_remote_error_ATTEMPT_TO_CREATE_AN_ACCOUNT_THAT_ALREADY_EXISTS;
            }
            if (this.isAccountDoesNotExist()) {
                return R.string.fxaccount_remote_error_ATTEMPT_TO_ACCESS_AN_ACCOUNT_THAT_DOES_NOT_EXIST;
            }
            if (this.isBadPassword()) {
                return R.string.fxaccount_remote_error_INCORRECT_PASSWORD;
            }
            if (this.isUnverified()) {
                return R.string.fxaccount_remote_error_ATTEMPT_TO_OPERATE_ON_AN_UNVERIFIED_ACCOUNT;
            }
            if (this.isTooManyRequests()) {
                return R.string.fxaccount_remote_error_CLIENT_HAS_SENT_TOO_MANY_REQUESTS;
            }
            if (this.isServerUnavailable()) {
                return R.string.fxaccount_remote_error_SERVICE_TEMPORARILY_UNAVAILABLE_TO_DUE_HIGH_LOAD;
            }
            return R.string.fxaccount_remote_error_UNKNOWN_ERROR;
        }
    }
}

