/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.browserid.verifier;

import ch.boye.httpclientandroidlib.HttpEntity;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.NameValuePair;
import ch.boye.httpclientandroidlib.client.ClientProtocolException;
import ch.boye.httpclientandroidlib.client.entity.UrlEncodedFormEntity;
import ch.boye.httpclientandroidlib.message.BasicNameValuePair;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.List;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.browserid.verifier.BrowserIDVerifierClient;
import org.mozilla.gecko.browserid.verifier.BrowserIDVerifierDelegate;
import org.mozilla.gecko.browserid.verifier.BrowserIDVerifierException;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.net.BaseResource;
import org.mozilla.gecko.sync.net.BaseResourceDelegate;
import org.mozilla.gecko.sync.net.Resource;
import org.mozilla.gecko.sync.net.SyncResponse;

public class BrowserIDRemoteVerifierClient
implements BrowserIDVerifierClient {
    public static final String LOG_TAG = "BrowserIDRemoteVerifierClient";
    public static final String DEFAULT_VERIFIER_URL = "https://verifier.login.persona.org/verify";
    protected final URI verifierUri;

    public BrowserIDRemoteVerifierClient(URI uRI) {
        this.verifierUri = uRI;
    }

    public BrowserIDRemoteVerifierClient() throws URISyntaxException {
        this.verifierUri = new URI(DEFAULT_VERIFIER_URL);
    }

    public void verify(String string2, String string3, BrowserIDVerifierDelegate browserIDVerifierDelegate) {
        if (string2 == null) {
            throw new IllegalArgumentException("audience cannot be null.");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("assertion cannot be null.");
        }
        if (browserIDVerifierDelegate == null) {
            throw new IllegalArgumentException("delegate cannot be null.");
        }
        BaseResource baseResource = new BaseResource(this.verifierUri);
        baseResource.delegate = new RemoteVerifierResourceDelegate(baseResource, browserIDVerifierDelegate);
        List<NameValuePair> list = Arrays.asList(new BasicNameValuePair("audience", string2), new BasicNameValuePair("assertion", string3));
        try {
            baseResource.post((HttpEntity)new UrlEncodedFormEntity(list, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            browserIDVerifierDelegate.handleError(unsupportedEncodingException);
        }
    }

    protected static class RemoteVerifierResourceDelegate
    extends BaseResourceDelegate {
        private final BrowserIDVerifierDelegate delegate;

        protected RemoteVerifierResourceDelegate(Resource resource, BrowserIDVerifierDelegate browserIDVerifierDelegate) {
            super(resource);
            this.delegate = browserIDVerifierDelegate;
        }

        public String getUserAgent() {
            return null;
        }

        public void handleHttpResponse(HttpResponse httpResponse) {
            SyncResponse syncResponse = new SyncResponse(httpResponse);
            int n = syncResponse.getStatusCode();
            Logger.debug(BrowserIDRemoteVerifierClient.LOG_TAG, "Got response with status code " + n + ".");
            if (n != 200) {
                this.delegate.handleError(new BrowserIDVerifierException.BrowserIDVerifierErrorResponseException("Expected status code 200."));
                return;
            }
            ExtendedJSONObject extendedJSONObject = null;
            try {
                extendedJSONObject = syncResponse.jsonObjectBody();
            }
            catch (Exception exception) {
                this.delegate.handleError(new BrowserIDVerifierException.BrowserIDVerifierMalformedResponseException(exception));
                return;
            }
            String string2 = extendedJSONObject.getString("status");
            if ("failure".equals(string2)) {
                this.delegate.handleFailure(extendedJSONObject);
                return;
            }
            if (!"okay".equals(string2)) {
                this.delegate.handleError(new BrowserIDVerifierException.BrowserIDVerifierMalformedResponseException("Expected status okay, got '" + string2 + "'."));
                return;
            }
            this.delegate.handleSuccess(extendedJSONObject);
        }

        public void handleTransportException(GeneralSecurityException generalSecurityException) {
            Logger.warn(BrowserIDRemoteVerifierClient.LOG_TAG, "Got transport exception.", generalSecurityException);
            this.delegate.handleError(generalSecurityException);
        }

        public void handleHttpProtocolException(ClientProtocolException clientProtocolException) {
            Logger.warn(BrowserIDRemoteVerifierClient.LOG_TAG, "Got protocol exception.", clientProtocolException);
            this.delegate.handleError((Exception)((Object)clientProtocolException));
        }

        public void handleHttpIOException(IOException iOException) {
            Logger.warn(BrowserIDRemoteVerifierClient.LOG_TAG, "Got IO exception.", iOException);
            this.delegate.handleError(iOException);
        }
    }
}

