/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.favicons.cache;

import android.graphics.Bitmap;
import org.mozilla.gecko.favicons.cache.FaviconsForURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaviconCacheElement
implements Comparable<FaviconCacheElement> {
    final boolean isPrimary;
    Bitmap faviconPayload;
    volatile boolean invalidated;
    final int imageSize;
    final FaviconsForURL backpointer;

    public FaviconCacheElement(Bitmap bitmap, boolean bl, int n, FaviconsForURL faviconsForURL) {
        this.faviconPayload = bitmap;
        this.isPrimary = bl;
        this.imageSize = n;
        this.backpointer = faviconsForURL;
    }

    public FaviconCacheElement(Bitmap bitmap, boolean bl, FaviconsForURL faviconsForURL) {
        this.faviconPayload = bitmap;
        this.isPrimary = bl;
        this.backpointer = faviconsForURL;
        this.imageSize = bitmap != null ? bitmap.getWidth() : 0;
    }

    public int sizeOf() {
        if (this.invalidated) {
            return 0;
        }
        return this.faviconPayload.getRowBytes() * this.faviconPayload.getHeight();
    }

    @Override
    public int compareTo(FaviconCacheElement faviconCacheElement) {
        if (this.invalidated && !faviconCacheElement.invalidated) {
            return -1;
        }
        if (!this.invalidated && faviconCacheElement.invalidated) {
            return 1;
        }
        if (this.invalidated) {
            return 0;
        }
        int n = this.imageSize;
        int n2 = faviconCacheElement.imageSize;
        if (n > n2) {
            return 1;
        }
        if (n2 > n) {
            return -1;
        }
        return 0;
    }

    public void onEvictedFromCache() {
        if (this.isPrimary) {
            this.invalidated = true;
            this.faviconPayload = null;
        } else {
            if (this.backpointer == null) {
                return;
            }
            this.backpointer.favicons.remove(this);
        }
    }
}

