/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.favicons.decoders;

import org.mozilla.gecko.favicons.decoders.FaviconDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IconDirectoryEntry
implements Comparable<IconDirectoryEntry> {
    public static int maxBPP;
    int width;
    int height;
    int paletteSize;
    int bitsPerPixel;
    int payloadSize;
    int payloadOffset;
    boolean payloadIsPNG;
    int index;
    boolean isErroneous;

    public IconDirectoryEntry(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this.width = n;
        this.height = n2;
        this.paletteSize = n3;
        this.bitsPerPixel = n4;
        this.payloadSize = n5;
        this.payloadOffset = n6;
        this.payloadIsPNG = bl;
    }

    public static IconDirectoryEntry getErroneousEntry() {
        IconDirectoryEntry iconDirectoryEntry = new IconDirectoryEntry(-1, -1, -1, -1, -1, -1, false);
        iconDirectoryEntry.isErroneous = true;
        return iconDirectoryEntry;
    }

    public static IconDirectoryEntry createFromBuffer(byte[] byArray, int n, int n2, int n3) {
        int n4;
        if (byArray[n3 + 3] != 0) {
            return IconDirectoryEntry.getErroneousEntry();
        }
        int n5 = n3 + 8;
        int n6 = byArray[n5] & 0xFF | (byArray[n5 + 1] & 0xFF) << 8 | (byArray[n5 + 2] & 0xFF) << 16 | (byArray[n5 + 3] & 0xFF) << 24;
        if ((n4 = byArray[n5 += 4] & 0xFF | (byArray[n5 + 1] & 0xFF) << 8 | (byArray[n5 + 2] & 0xFF) << 16 | (byArray[n5 + 3] & 0xFF) << 24) < 0 || n6 < 0 || n4 + n6 > n + n2) {
            return IconDirectoryEntry.getErroneousEntry();
        }
        int n7 = byArray[n3] & 0xFF;
        int n8 = byArray[n3 + 1] & 0xFF;
        if (n7 == 0) {
            n7 = 256;
        }
        if (n8 == 0) {
            n8 = 256;
        }
        int n9 = byArray[n3 + 2] & 0xFF;
        int n10 = byArray[n3 + 4] & 0xFF;
        int n11 = byArray[n3 + 6] & 0xFF | (byArray[n3 + 7] & 0xFF) << 8;
        if (n10 > 1) {
            n11 *= n10;
        }
        boolean bl = FaviconDecoder.bufferStartsWith(byArray, FaviconDecoder.ImageMagicNumbers.PNG.value, n + n4);
        return new IconDirectoryEntry(n7, n8, n9, n11, n6, n4, bl);
    }

    public int getOffset() {
        return 6 + this.index * 16;
    }

    @Override
    public int compareTo(IconDirectoryEntry iconDirectoryEntry) {
        if (this.width > iconDirectoryEntry.width) {
            return 1;
        }
        if (this.width < iconDirectoryEntry.width) {
            return -1;
        }
        if (this.bitsPerPixel >= maxBPP && iconDirectoryEntry.bitsPerPixel >= maxBPP) {
            if (this.bitsPerPixel < iconDirectoryEntry.bitsPerPixel) {
                return 1;
            }
            if (this.bitsPerPixel > iconDirectoryEntry.bitsPerPixel) {
                return -1;
            }
        }
        if (this.bitsPerPixel > iconDirectoryEntry.bitsPerPixel) {
            return 1;
        }
        if (this.bitsPerPixel < iconDirectoryEntry.bitsPerPixel) {
            return -1;
        }
        if (this.paletteSize > iconDirectoryEntry.paletteSize) {
            return 1;
        }
        if (this.paletteSize < iconDirectoryEntry.paletteSize) {
            return -1;
        }
        if (this.payloadSize < iconDirectoryEntry.payloadSize) {
            return 1;
        }
        if (this.payloadSize > iconDirectoryEntry.payloadSize) {
            return -1;
        }
        if (this.payloadIsPNG && !iconDirectoryEntry.payloadIsPNG) {
            return 1;
        }
        if (!this.payloadIsPNG && iconDirectoryEntry.payloadIsPNG) {
            return -1;
        }
        return 0;
    }

    public static void setMaxBPP(int n) {
        maxBPP = n;
    }

    public String toString() {
        return "IconDirectoryEntry{\nwidth=" + this.width + ", \nheight=" + this.height + ", \npaletteSize=" + this.paletteSize + ", \nbitsPerPixel=" + this.bitsPerPixel + ", \npayloadSize=" + this.payloadSize + ", \npayloadOffset=" + this.payloadOffset + ", \npayloadIsPNG=" + this.payloadIsPNG + ", \nindex=" + this.index + '}';
    }
}

