/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mozilla.gecko.R;
import org.mozilla.gecko.home.HomeConfig;
import org.mozilla.gecko.home.HomeConfigLoader;
import org.mozilla.gecko.home.HomePanelsManager;
import org.mozilla.gecko.home.PanelInfoManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HomePanelPicker
extends FragmentActivity {
    private static final String LOGTAG = "HomePanelPicker";
    public static final String CURRENT_PANELS_IDS = "currentPanelsIds";
    public static final int REQUEST_CODE_ADD_PANEL = 1;
    private static final int LOADER_ID_CONFIG = 0;
    private ListView mListView;
    private List<String> mCurrentPanelsIds;
    private List<PanelInfoManager.PanelInfo> mPanelInfos;

    public void onCreate(Bundle bundle) {
        Object object;
        super.onCreate(bundle);
        this.setContentView(R.layout.home_panel_picker);
        Bundle bundle2 = this.getIntent().getExtras();
        if (bundle2 != null && (object = bundle2.getStringArray(CURRENT_PANELS_IDS)) != null) {
            this.mCurrentPanelsIds = Arrays.asList(object);
        }
        this.mListView = (ListView)this.findViewById(R.id.list);
        object = new PickerAdapter((Context)this);
        this.mListView.setAdapter((ListAdapter)object);
        this.requestAvailablePanels();
    }

    private void requestAvailablePanels() {
        PanelInfoManager panelInfoManager = new PanelInfoManager();
        panelInfoManager.requestAvailablePanels(new PanelInfoManager.RequestCallback(){

            @Override
            public void onComplete(List<PanelInfoManager.PanelInfo> list) {
                HomePanelPicker.this.mPanelInfos = list;
                if (HomePanelPicker.this.mCurrentPanelsIds == null) {
                    HomePanelPicker.this.loadConfig();
                } else {
                    HomePanelPicker.this.updatePanelsAdapter(HomePanelPicker.this.mPanelInfos);
                }
            }
        });
    }

    private void loadConfig() {
        ConfigLoaderCallbacks configLoaderCallbacks = new ConfigLoaderCallbacks();
        LoaderManager loaderManager = this.getSupportLoaderManager();
        loaderManager.initLoader(0, null, (LoaderManager.LoaderCallbacks)configLoaderCallbacks);
    }

    private void updatePanelsAdapter(List<PanelInfoManager.PanelInfo> list) {
        ArrayList<PanelInfoManager.PanelInfo> arrayList = new ArrayList<PanelInfoManager.PanelInfo>();
        for (PanelInfoManager.PanelInfo panelInfo : list) {
            if (this.mCurrentPanelsIds.contains(panelInfo.getId())) continue;
            arrayList.add(panelInfo);
        }
        if (arrayList.isEmpty()) {
            this.setContentView(R.layout.home_panel_picker_empty);
            return;
        }
        PickerAdapter pickerAdapter = (PickerAdapter)this.mListView.getAdapter();
        pickerAdapter.updateFromPanelInfos(arrayList);
    }

    private void installNewPanelAndQuit(PanelInfoManager.PanelInfo panelInfo) {
        HomeConfig.PanelConfig panelConfig = panelInfo.toPanelConfig();
        HomePanelsManager.getInstance().installPanel(panelConfig);
        this.showToastForNewPanel(panelConfig);
        this.setResult(-1);
        this.finish();
    }

    private void showToastForNewPanel(HomeConfig.PanelConfig panelConfig) {
        String string2 = panelConfig.getTitle();
        String string3 = this.getResources().getString(R.string.home_add_panel_installed, new Object[]{string2});
        Toast.makeText((Context)this, (CharSequence)string3, (int)0).show();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConfigLoaderCallbacks
    implements LoaderManager.LoaderCallbacks<HomeConfig.State> {
        private ConfigLoaderCallbacks() {
        }

        public Loader<HomeConfig.State> onCreateLoader(int n, Bundle bundle) {
            HomeConfig homeConfig = HomeConfig.getDefault((Context)HomePanelPicker.this);
            return new HomeConfigLoader((Context)HomePanelPicker.this, homeConfig);
        }

        public void onLoadFinished(Loader<HomeConfig.State> loader, HomeConfig.State state) {
            HomePanelPicker.this.mCurrentPanelsIds = new ArrayList();
            for (HomeConfig.PanelConfig panelConfig : state) {
                HomePanelPicker.this.mCurrentPanelsIds.add(panelConfig.getId());
            }
            HomePanelPicker.this.updatePanelsAdapter(HomePanelPicker.this.mPanelInfos);
        }

        public void onLoaderReset(Loader<HomeConfig.State> loader) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PickerAdapter
    extends BaseAdapter {
        private final LayoutInflater mInflater;
        private List<PanelInfoManager.PanelInfo> mPanelInfos;
        private final View.OnClickListener mOnClickListener;

        public PickerAdapter(Context context) {
            this(context, null);
        }

        public PickerAdapter(Context context, List<PanelInfoManager.PanelInfo> list) {
            this.mInflater = LayoutInflater.from((Context)context);
            this.mPanelInfos = list;
            this.mOnClickListener = new View.OnClickListener(){

                public void onClick(View view) {
                    PanelRow panelRow = (PanelRow)view.getTag();
                    HomePanelPicker.this.installNewPanelAndQuit((PanelInfoManager.PanelInfo)PickerAdapter.this.mPanelInfos.get(panelRow.position));
                }
            };
        }

        public int getCount() {
            if (this.mPanelInfos == null) {
                return 0;
            }
            return this.mPanelInfos.size();
        }

        public PanelInfoManager.PanelInfo getItem(int n) {
            if (this.mPanelInfos == null) {
                return null;
            }
            return this.mPanelInfos.get(n);
        }

        public long getItemId(int n) {
            return n;
        }

        public View getView(int n, View view, ViewGroup viewGroup) {
            PanelRow panelRow;
            if (view == null) {
                view = this.mInflater.inflate(R.layout.home_panel_picker_row, null);
                view.setOnClickListener(this.mOnClickListener);
                panelRow = new PanelRow(view);
                view.setTag((Object)panelRow);
            } else {
                panelRow = (PanelRow)view.getTag();
            }
            panelRow.title.setText((CharSequence)this.mPanelInfos.get(n).getTitle());
            panelRow.position = n;
            return view;
        }

        public void updateFromPanelInfos(List<PanelInfoManager.PanelInfo> list) {
            this.mPanelInfos = list;
            this.notifyDataSetChanged();
        }
    }

    private static class PanelRow {
        final TextView title;
        int position;

        public PanelRow(View view) {
            this.title = (TextView)view.findViewById(R.id.title);
        }
    }
}

