/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Configuration;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.SystemClock;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.AsyncTaskLoader;
import android.support.v4.content.Loader;
import android.support.v4.widget.CursorAdapter;
import android.text.TextUtils;
import android.util.Log;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.favicons.OnFaviconLoadedListener;
import org.mozilla.gecko.gfx.BitmapUtils;
import org.mozilla.gecko.home.HomeContextMenuInfo;
import org.mozilla.gecko.home.HomeFragment;
import org.mozilla.gecko.home.HomeListView;
import org.mozilla.gecko.home.HomePager;
import org.mozilla.gecko.home.PinSiteDialog;
import org.mozilla.gecko.home.SimpleCursorLoader;
import org.mozilla.gecko.home.TopSitesGridItemView;
import org.mozilla.gecko.home.TopSitesGridView;
import org.mozilla.gecko.home.TwoLinePageRow;
import org.mozilla.gecko.util.StringUtils;
import org.mozilla.gecko.util.ThreadUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopSitesPanel
extends HomeFragment {
    private static final String LOGTAG = "GeckoTopSitesPanel";
    private static final int LOADER_ID_TOP_SITES = 0;
    private static final int LOADER_ID_THUMBNAILS = 1;
    private static final String THUMBNAILS_URLS_KEY = "urls";
    private VisitedAdapter mListAdapter;
    private TopSitesGridAdapter mGridAdapter;
    private HomeListView mList;
    private TopSitesGridView mGrid;
    private CursorLoaderCallbacks mCursorLoaderCallbacks;
    private ThumbnailsLoaderCallbacks mThumbnailsLoaderCallbacks;
    private EditPinnedSiteListener mEditPinnedSiteListener;
    private HomePager.OnUrlOpenListener mUrlOpenListener = null;
    private int mMaxGridEntries;
    private static final long PRIORITY_RESET_TIMEOUT = 10000L;
    private static boolean logDebug = Log.isLoggable((String)"GeckoTopSitesPanel", (int)3);
    private static boolean logVerbose = Log.isLoggable((String)"GeckoTopSitesPanel", (int)2);

    public static TopSitesPanel newInstance() {
        return new TopSitesPanel();
    }

    private static void debug(String string2) {
        if (logDebug) {
            Log.d((String)LOGTAG, (String)string2);
        }
    }

    private static void trace(String string2) {
        if (logVerbose) {
            Log.v((String)LOGTAG, (String)string2);
        }
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.mMaxGridEntries = activity.getResources().getInteger(R.integer.number_of_top_sites);
        try {
            this.mUrlOpenListener = (HomePager.OnUrlOpenListener)activity;
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException(activity.toString() + " must implement HomePager.OnUrlOpenListener");
        }
    }

    public void onDetach() {
        super.onDetach();
        this.mUrlOpenListener = null;
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View view = layoutInflater.inflate(R.layout.home_top_sites_panel, viewGroup, false);
        this.mList = (HomeListView)view.findViewById(R.id.list);
        this.mGrid = new TopSitesGridView((Context)this.getActivity());
        this.mList.addHeaderView((View)this.mGrid);
        return view;
    }

    public void onViewCreated(View view, Bundle bundle) {
        this.mEditPinnedSiteListener = new EditPinnedSiteListener();
        this.mList.setTag("top_sites");
        this.mList.setHeaderDividersEnabled(false);
        this.mList.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                ListView listView = (ListView)adapterView;
                int n2 = listView.getHeaderViewsCount();
                if (n < n2) {
                    return;
                }
                Cursor cursor = TopSitesPanel.this.mListAdapter.getCursor();
                if (cursor == null || !cursor.moveToPosition(n += TopSitesPanel.this.mGridAdapter.getCount() - n2)) {
                    return;
                }
                String string2 = cursor.getString(cursor.getColumnIndexOrThrow("url"));
                Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.LIST_ITEM);
                TopSitesPanel.this.mUrlOpenListener.onUrlOpen(string2, EnumSet.of(HomePager.OnUrlOpenListener.Flags.ALLOW_SWITCH_TO_TAB));
            }
        });
        this.mList.setContextMenuInfoFactory(new HomeContextMenuInfo.Factory(){

            public HomeContextMenuInfo makeInfoForCursor(View view, int n, long l, Cursor cursor) {
                HomeContextMenuInfo homeContextMenuInfo = new HomeContextMenuInfo(view, n, l);
                homeContextMenuInfo.url = cursor.getString(cursor.getColumnIndexOrThrow("url"));
                homeContextMenuInfo.title = cursor.getString(cursor.getColumnIndexOrThrow("title"));
                homeContextMenuInfo.historyId = cursor.getInt(cursor.getColumnIndexOrThrow("history_id"));
                int n2 = cursor.getColumnIndexOrThrow("bookmark_id");
                homeContextMenuInfo.bookmarkId = cursor.isNull(n2) ? -1 : cursor.getInt(n2);
                return homeContextMenuInfo;
            }
        });
        this.mGrid.setOnUrlOpenListener(this.mUrlOpenListener);
        this.mGrid.setOnEditPinnedSiteListener(this.mEditPinnedSiteListener);
        this.registerForContextMenu((View)this.mList);
        this.registerForContextMenu((View)this.mGrid);
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.mList.setOnItemClickListener(null);
        this.mList = null;
        this.mGrid = null;
        this.mListAdapter = null;
        this.mGridAdapter = null;
    }

    @Override
    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        if (this.isVisible()) {
            this.getFragmentManager().beginTransaction().detach((Fragment)this).attach((Fragment)this).commitAllowingStateLoss();
        }
    }

    public void onActivityCreated(Bundle bundle) {
        super.onActivityCreated(bundle);
        FragmentActivity fragmentActivity = this.getActivity();
        this.mGridAdapter = new TopSitesGridAdapter((Context)fragmentActivity, null);
        this.mGrid.setAdapter((ListAdapter)this.mGridAdapter);
        this.mListAdapter = new VisitedAdapter((Context)fragmentActivity, null);
        this.mList.setAdapter((ListAdapter)this.mListAdapter);
        this.mCursorLoaderCallbacks = new CursorLoaderCallbacks();
        this.mThumbnailsLoaderCallbacks = new ThumbnailsLoaderCallbacks();
        this.loadIfVisible();
    }

    @Override
    public void onCreateContextMenu(ContextMenu contextMenu, View view, ContextMenu.ContextMenuInfo contextMenuInfo) {
        if (contextMenuInfo == null) {
            return;
        }
        if (!(contextMenuInfo instanceof TopSitesGridView.TopSitesGridContextMenuInfo)) {
            super.onCreateContextMenu(contextMenu, view, contextMenuInfo);
            return;
        }
        MenuInflater menuInflater = new MenuInflater(view.getContext());
        menuInflater.inflate(R.menu.home_contextmenu, (Menu)contextMenu);
        contextMenu.findItem(R.id.home_open_in_reader).setVisible(false);
        contextMenu.findItem(R.id.home_edit_bookmark).setVisible(false);
        TopSitesGridView.TopSitesGridContextMenuInfo topSitesGridContextMenuInfo = (TopSitesGridView.TopSitesGridContextMenuInfo)contextMenuInfo;
        contextMenu.setHeaderTitle((CharSequence)topSitesGridContextMenuInfo.getDisplayTitle());
        if (topSitesGridContextMenuInfo.type != 0) {
            if (topSitesGridContextMenuInfo.type == 2) {
                contextMenu.findItem(R.id.top_sites_pin).setVisible(false);
            } else {
                contextMenu.findItem(R.id.top_sites_unpin).setVisible(false);
            }
        } else {
            contextMenu.findItem(R.id.home_open_new_tab).setVisible(false);
            contextMenu.findItem(R.id.home_open_private_tab).setVisible(false);
            contextMenu.findItem(R.id.top_sites_pin).setVisible(false);
            contextMenu.findItem(R.id.top_sites_unpin).setVisible(false);
        }
        if (!StringUtils.isShareableUrl((String)topSitesGridContextMenuInfo.url) || GeckoProfile.get((Context)this.getActivity()).inGuestMode()) {
            contextMenu.findItem(R.id.home_share).setVisible(false);
        }
    }

    @Override
    public boolean onContextItemSelected(MenuItem menuItem) {
        if (super.onContextItemSelected(menuItem)) {
            return true;
        }
        ContextMenu.ContextMenuInfo contextMenuInfo = menuItem.getMenuInfo();
        if (contextMenuInfo == null || !(contextMenuInfo instanceof TopSitesGridView.TopSitesGridContextMenuInfo)) {
            return false;
        }
        TopSitesGridView.TopSitesGridContextMenuInfo topSitesGridContextMenuInfo = (TopSitesGridView.TopSitesGridContextMenuInfo)contextMenuInfo;
        int n = menuItem.getItemId();
        if (n == R.id.top_sites_pin) {
            final String string2 = topSitesGridContextMenuInfo.url;
            final String string3 = topSitesGridContextMenuInfo.title;
            final int n2 = topSitesGridContextMenuInfo.position;
            final Context context = this.getActivity().getApplicationContext();
            ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                public void run() {
                    BrowserDB.pinSite(context.getContentResolver(), string2, string3, n2);
                }
            });
            Telemetry.sendUIEvent(TelemetryContract.Event.PIN);
            return true;
        }
        if (n == R.id.top_sites_unpin) {
            final int n3 = topSitesGridContextMenuInfo.position;
            final Context context = this.getActivity().getApplicationContext();
            ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                public void run() {
                    BrowserDB.unpinSite(context.getContentResolver(), n3);
                }
            });
            Telemetry.sendUIEvent(TelemetryContract.Event.UNPIN);
            return true;
        }
        if (n == R.id.top_sites_edit) {
            this.mEditPinnedSiteListener.onEditPinnedSite(topSitesGridContextMenuInfo.position, TopSitesPanel.decodeUserEnteredUrl(topSitesGridContextMenuInfo.url));
            Telemetry.sendUIEvent(TelemetryContract.Event.EDIT);
            return true;
        }
        return false;
    }

    @Override
    protected void load() {
        this.getLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)this.mCursorLoaderCallbacks);
        ThreadUtils.reduceGeckoPriority((long)10000L);
    }

    static String encodeUserEnteredUrl(String string2) {
        return Uri.fromParts((String)"user-entered", (String)string2, null).toString();
    }

    private void updateUiFromCursor(Cursor cursor) {
        this.mList.setHeaderDividersEnabled(cursor != null && cursor.getCount() > this.mMaxGridEntries);
    }

    private void updateUiWithThumbnails(Map<String, Bitmap> map) {
        if (this.mGridAdapter != null) {
            this.mGridAdapter.updateThumbnails(map);
        }
        ThreadUtils.resetGeckoPriority();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ThumbnailsLoaderCallbacks
    implements LoaderManager.LoaderCallbacks<Map<String, Bitmap>> {
        private ThumbnailsLoaderCallbacks() {
        }

        public Loader<Map<String, Bitmap>> onCreateLoader(int n, Bundle bundle) {
            return new ThumbnailsLoader((Context)TopSitesPanel.this.getActivity(), bundle.getStringArrayList(TopSitesPanel.THUMBNAILS_URLS_KEY));
        }

        public void onLoadFinished(Loader<Map<String, Bitmap>> loader, Map<String, Bitmap> map) {
            TopSitesPanel.this.updateUiWithThumbnails(map);
        }

        public void onLoaderReset(Loader<Map<String, Bitmap>> loader) {
            if (TopSitesPanel.this.mGridAdapter != null) {
                TopSitesPanel.this.mGridAdapter.updateThumbnails(null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThumbnailsLoader
    extends AsyncTaskLoader<Map<String, Bitmap>> {
        private Map<String, Bitmap> mThumbnails;
        private ArrayList<String> mUrls;

        public ThumbnailsLoader(Context context, ArrayList<String> arrayList) {
            super(context);
            this.mUrls = arrayList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, Bitmap> loadInBackground() {
            if (this.mUrls == null || this.mUrls.size() == 0) {
                return null;
            }
            ContentResolver contentResolver = this.getContext().getContentResolver();
            Cursor cursor = BrowserDB.getThumbnailsForUrls(contentResolver, this.mUrls);
            if (cursor == null) {
                return null;
            }
            HashMap<String, Bitmap> hashMap = new HashMap<String, Bitmap>();
            try {
                int n = cursor.getColumnIndexOrThrow("url");
                int n2 = cursor.getColumnIndexOrThrow("data");
                while (cursor.moveToNext()) {
                    String string2 = cursor.getString(n);
                    byte[] byArray = cursor.getBlob(n2);
                    if (byArray == null) continue;
                    Bitmap bitmap = BitmapUtils.decodeByteArray(byArray);
                    if (bitmap == null) {
                        Log.w((String)TopSitesPanel.LOGTAG, (String)"Aborting thumbnail load; decode failed.");
                        break;
                    }
                    hashMap.put(string2, bitmap);
                }
            }
            finally {
                cursor.close();
            }
            return hashMap;
        }

        public void deliverResult(Map<String, Bitmap> map) {
            if (this.isReset()) {
                this.mThumbnails = null;
                return;
            }
            this.mThumbnails = map;
            if (this.isStarted()) {
                super.deliverResult(map);
            }
        }

        protected void onStartLoading() {
            if (this.mThumbnails != null) {
                this.deliverResult(this.mThumbnails);
            }
            if (this.takeContentChanged() || this.mThumbnails == null) {
                this.forceLoad();
            }
        }

        protected void onStopLoading() {
            this.cancelLoad();
        }

        public void onCanceled(Map<String, Bitmap> map) {
            this.mThumbnails = null;
        }

        protected void onReset() {
            super.onReset();
            this.onStopLoading();
            this.mThumbnails = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CursorLoaderCallbacks
    implements LoaderManager.LoaderCallbacks<Cursor> {
        private CursorLoaderCallbacks() {
        }

        public Loader<Cursor> onCreateLoader(int n, Bundle bundle) {
            TopSitesPanel.trace("Creating TopSitesLoader: " + n);
            return new TopSitesLoader((Context)TopSitesPanel.this.getActivity());
        }

        public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
            String string2;
            TopSitesPanel.debug("onLoadFinished: " + cursor.getCount() + " rows.");
            TopSitesPanel.this.mListAdapter.swapCursor(cursor);
            TopSitesPanel.this.mGridAdapter.swapCursor(cursor);
            TopSitesPanel.this.updateUiFromCursor(cursor);
            int n = cursor.getColumnIndexOrThrow("url");
            if (!cursor.moveToFirst()) {
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = 1;
            do {
                if (TextUtils.isEmpty((CharSequence)(string2 = cursor.getString(n))) || BrowserDB.hasSuggestedImageUrl(string2)) continue;
                arrayList.add(string2);
            } while (n2++ < TopSitesPanel.this.mMaxGridEntries && cursor.moveToNext());
            if (arrayList.isEmpty()) {
                TopSitesPanel.this.updateUiWithThumbnails(new HashMap());
                return;
            }
            string2 = new Bundle();
            string2.putStringArrayList(TopSitesPanel.THUMBNAILS_URLS_KEY, arrayList);
            TopSitesPanel.this.getLoaderManager().restartLoader(1, (Bundle)string2, (LoaderManager.LoaderCallbacks)TopSitesPanel.this.mThumbnailsLoaderCallbacks);
        }

        public void onLoaderReset(Loader<Cursor> loader) {
            if (TopSitesPanel.this.mListAdapter != null) {
                TopSitesPanel.this.mListAdapter.swapCursor(null);
            }
            if (TopSitesPanel.this.mGridAdapter != null) {
                TopSitesPanel.this.mGridAdapter.swapCursor(null);
            }
        }
    }

    private static class LoadIDAwareFaviconLoadedListener
    implements OnFaviconLoadedListener {
        private volatile int loadId = 0;
        private final TopSitesGridItemView view;

        public LoadIDAwareFaviconLoadedListener(TopSitesGridItemView topSitesGridItemView) {
            this.view = topSitesGridItemView;
        }

        public void setLoadId(int n) {
            this.loadId = n;
        }

        public void onFaviconLoaded(String string2, String string3, Bitmap bitmap) {
            if (TextUtils.equals((CharSequence)this.view.getUrl(), (CharSequence)string2)) {
                this.view.displayFavicon(bitmap, string3, this.loadId);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TopSitesGridAdapter
    extends CursorAdapter {
        private Map<String, Bitmap> mThumbnails;

        public TopSitesGridAdapter(Context context, Cursor cursor) {
            super(context, cursor, 0);
        }

        public int getCount() {
            return Math.min(TopSitesPanel.this.mMaxGridEntries, super.getCount());
        }

        protected void onContentChanged() {
        }

        public void updateThumbnails(Map<String, Bitmap> map) {
            this.mThumbnails = map;
            int n = TopSitesPanel.this.mGrid.getChildCount();
            for (int i = 0; i < n; ++i) {
                TopSitesGridItemView topSitesGridItemView = (TopSitesGridItemView)TopSitesPanel.this.mGrid.getChildAt(i);
                topSitesGridItemView.markAsDirty();
            }
            this.notifyDataSetChanged();
        }

        public void bindView(View view, Context context, Cursor cursor) {
            String string2 = cursor.getString(cursor.getColumnIndexOrThrow("url"));
            String string3 = cursor.getString(cursor.getColumnIndexOrThrow("title"));
            int n = cursor.getInt(cursor.getColumnIndexOrThrow("type"));
            TopSitesGridItemView topSitesGridItemView = (TopSitesGridItemView)view;
            if (n == 0) {
                topSitesGridItemView.blankOut();
                return;
            }
            Bitmap bitmap = this.mThumbnails != null ? this.mThumbnails.get(string2) : null;
            boolean bl = topSitesGridItemView.updateState(string3, string2, n, bitmap);
            if (!bl) {
                TopSitesPanel.debug("bindView called twice for same values; short-circuiting.");
                return;
            }
            String string4 = BrowserDB.getSuggestedImageUrlForUrl(string2);
            if (!TextUtils.isEmpty((CharSequence)string4)) {
                int n2 = BrowserDB.getSuggestedBackgroundColorForUrl(string2);
                topSitesGridItemView.displayThumbnail(string4, n2);
                return;
            }
            if (this.mThumbnails == null || bitmap != null) {
                return;
            }
            LoadIDAwareFaviconLoadedListener loadIDAwareFaviconLoadedListener = new LoadIDAwareFaviconLoadedListener(topSitesGridItemView);
            int n3 = Favicons.getSizedFaviconForPageFromLocal(string2, loadIDAwareFaviconLoadedListener);
            if (n3 == 1) {
                return;
            }
            topSitesGridItemView.displayThumbnail(R.drawable.favicon);
            loadIDAwareFaviconLoadedListener.setLoadId(n3);
            topSitesGridItemView.setLoadId(n3);
        }

        public View newView(Context context, Cursor cursor, ViewGroup viewGroup) {
            return new TopSitesGridItemView(context);
        }
    }

    private class VisitedAdapter
    extends CursorAdapter {
        public VisitedAdapter(Context context, Cursor cursor) {
            super(context, cursor, 0);
        }

        public int getCount() {
            return Math.max(0, super.getCount() - TopSitesPanel.this.mMaxGridEntries);
        }

        public Object getItem(int n) {
            return super.getItem(n + TopSitesPanel.this.mMaxGridEntries);
        }

        public void bindView(View view, Context context, Cursor cursor) {
            int n = cursor.getPosition();
            cursor.moveToPosition(n + TopSitesPanel.this.mMaxGridEntries);
            TwoLinePageRow twoLinePageRow = (TwoLinePageRow)view;
            twoLinePageRow.updateFromCursor(cursor);
        }

        public View newView(Context context, Cursor cursor, ViewGroup viewGroup) {
            return LayoutInflater.from((Context)context).inflate(R.layout.bookmark_item_row, viewGroup, false);
        }
    }

    private static class TopSitesLoader
    extends SimpleCursorLoader {
        private static final int SEARCH_LIMIT = 30;
        private static final String TELEMETRY_HISTOGRAM_LOAD_CURSOR = "FENNEC_TOPSITES_LOADER_TIME_MS";
        private int mMaxGridEntries;

        public TopSitesLoader(Context context) {
            super(context);
            this.mMaxGridEntries = context.getResources().getInteger(R.integer.number_of_top_sites);
        }

        public Cursor loadCursor() {
            long l = SystemClock.uptimeMillis();
            Cursor cursor = BrowserDB.getTopSites(this.getContext().getContentResolver(), this.mMaxGridEntries, 30);
            long l2 = SystemClock.uptimeMillis();
            long l3 = l2 - l;
            Telemetry.HistogramAdd(TELEMETRY_HISTOGRAM_LOAD_CURSOR, (int)Math.min(l3, Integer.MAX_VALUE));
            return cursor;
        }
    }

    private class EditPinnedSiteListener
    implements TopSitesGridView.OnEditPinnedSiteListener,
    PinSiteDialog.OnSiteSelectedListener {
        private static final String TAG_PIN_SITE = "pin_site";
        private int mPosition;

        private EditPinnedSiteListener() {
        }

        public void onEditPinnedSite(int n, String string2) {
            this.mPosition = n;
            FragmentManager fragmentManager = TopSitesPanel.this.getChildFragmentManager();
            PinSiteDialog pinSiteDialog = (PinSiteDialog)fragmentManager.findFragmentByTag(TAG_PIN_SITE);
            if (pinSiteDialog == null) {
                pinSiteDialog = PinSiteDialog.newInstance();
            }
            pinSiteDialog.setOnSiteSelectedListener(this);
            pinSiteDialog.setSearchTerm(string2);
            pinSiteDialog.show(fragmentManager, TAG_PIN_SITE);
        }

        public void onSiteSelected(final String string2, final String string3) {
            final int n = this.mPosition;
            final Context context = TopSitesPanel.this.getActivity().getApplicationContext();
            ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                public void run() {
                    BrowserDB.pinSite(context.getContentResolver(), string2, string3, n);
                }
            });
        }
    }
}

