/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.setup.activities;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.Html;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.text.style.URLSpan;
import android.view.View;
import android.widget.TextView;
import java.util.Locale;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.setup.InvalidSyncKeyException;

public class ActivityUtils {
    private static final String LOG_TAG = "ActivityUtils";

    public static void prepareLogging() {
        Logger.setThreadLogTag("FxSync");
    }

    public static String validateSyncKey(String string2) throws InvalidSyncKeyException {
        String string3 = string2.trim().replace("-", "").toLowerCase(Locale.US);
        if (!string3.matches("^[abcdefghijkmnpqrstuvwxyz23456789]{26}$")) {
            throw new InvalidSyncKeyException();
        }
        return string3;
    }

    public static void openURLInFennec(Context context, String string2) {
        Intent intent;
        if (string2 != null) {
            intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)string2));
        } else {
            intent = new Intent("android.intent.action.MAIN");
        }
        intent.setClassName("org.mozilla.fennec", "org.mozilla.gecko.BrowserApp");
        intent.addFlags(0x10000000);
        context.startActivity(intent);
    }

    public static void linkTextView(TextView textView, int n, int n2) {
        Context context = textView.getContext();
        ActivityUtils.linkTextView(textView, context.getString(n), context.getString(n2));
    }

    public static void linkTextView(TextView textView, String string2, String string3) {
        textView.setText((CharSequence)("<a href=\"" + string3 + "\">" + string2 + "</a>"));
        ActivityUtils.linkifyTextView(textView, false);
    }

    public static void linkifyTextView(TextView textView, boolean bl) {
        URLSpan[] uRLSpanArray;
        if (textView == null) {
            Logger.warn(LOG_TAG, "Could not process links for view.");
            return;
        }
        textView.setMovementMethod(LinkMovementMethod.getInstance());
        Spanned spanned = Html.fromHtml((String)((Object)textView.getText()).toString());
        SpannableString spannableString = new SpannableString((CharSequence)spanned);
        for (URLSpan uRLSpan : uRLSpanArray = (URLSpan[])spannableString.getSpans(0, spannableString.length(), URLSpan.class)) {
            int n = spannableString.getSpanStart((Object)uRLSpan);
            int n2 = spannableString.getSpanEnd((Object)uRLSpan);
            int n3 = spannableString.getSpanFlags((Object)uRLSpan);
            spannableString.removeSpan((Object)uRLSpan);
            spannableString.setSpan((Object)new FennecClickableSpan(uRLSpan.getURL(), bl), n, n2, n3);
        }
        textView.setText((CharSequence)spannableString);
    }

    public static class FennecClickableSpan
    extends ClickableSpan {
        private final String url;
        private final boolean underlining;

        public FennecClickableSpan(String string2, boolean bl) {
            this.url = string2;
            this.underlining = bl;
        }

        public void updateDrawState(TextPaint textPaint) {
            super.updateDrawState(textPaint);
            if (!this.underlining) {
                textPaint.setUnderlineText(false);
            }
        }

        public void onClick(View view) {
            ActivityUtils.openURLInFennec(view.getContext(), this.url);
        }
    }
}

