/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.synchronizer;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.ThreadPool;
import org.mozilla.gecko.sync.repositories.InvalidSessionTransitionException;
import org.mozilla.gecko.sync.repositories.NoStoreDelegateException;
import org.mozilla.gecko.sync.repositories.RepositorySession;
import org.mozilla.gecko.sync.repositories.delegates.DeferredRepositorySessionBeginDelegate;
import org.mozilla.gecko.sync.repositories.delegates.DeferredRepositorySessionStoreDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionBeginDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionFetchRecordsDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionStoreDelegate;
import org.mozilla.gecko.sync.repositories.domain.Record;
import org.mozilla.gecko.sync.synchronizer.ConcurrentRecordConsumer;
import org.mozilla.gecko.sync.synchronizer.RecordConsumer;
import org.mozilla.gecko.sync.synchronizer.RecordsChannelDelegate;
import org.mozilla.gecko.sync.synchronizer.RecordsConsumerDelegate;
import org.mozilla.gecko.sync.synchronizer.SessionNotBegunException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordsChannel
implements RepositorySessionFetchRecordsDelegate,
RepositorySessionStoreDelegate,
RecordsConsumerDelegate,
RepositorySessionBeginDelegate {
    private static final String LOG_TAG = "RecordsChannel";
    public RepositorySession source;
    public RepositorySession sink;
    private RecordsChannelDelegate delegate;
    private long fetchEnd = -1L;
    protected final AtomicInteger numFetched = new AtomicInteger();
    protected final AtomicInteger numFetchFailed = new AtomicInteger();
    protected final AtomicInteger numStored = new AtomicInteger();
    protected final AtomicInteger numStoreFailed = new AtomicInteger();
    private RecordConsumer consumer;
    private boolean waitingForQueueDone = false;
    private ConcurrentLinkedQueue<Record> toProcess = new ConcurrentLinkedQueue();

    public RecordsChannel(RepositorySession repositorySession, RepositorySession repositorySession2, RecordsChannelDelegate recordsChannelDelegate) {
        this.source = repositorySession;
        this.sink = repositorySession2;
        this.delegate = recordsChannelDelegate;
    }

    @Override
    public ConcurrentLinkedQueue<Record> getQueue() {
        return this.toProcess;
    }

    protected boolean isReady() {
        return this.source.isActive() && this.sink.isActive();
    }

    public int getFetchCount() {
        return this.numFetched.get();
    }

    public int getFetchFailureCount() {
        return this.numFetchFailed.get();
    }

    public int getStoreCount() {
        return this.numStored.get();
    }

    public int getStoreFailureCount() {
        return this.numStoreFailed.get();
    }

    public void flow() {
        if (!this.isReady()) {
            RepositorySession repositorySession = this.source;
            if (this.source.isActive()) {
                repositorySession = this.sink;
            }
            this.delegate.onFlowBeginFailed(this, new SessionNotBegunException(repositorySession));
            return;
        }
        if (!this.source.dataAvailable()) {
            Logger.info(LOG_TAG, "No data available: short-circuiting flow from source " + this.source);
            long l = System.currentTimeMillis();
            this.delegate.onFlowCompleted(this, l, l);
            return;
        }
        this.sink.setStoreDelegate(this);
        this.numFetched.set(0);
        this.numFetchFailed.set(0);
        this.numStored.set(0);
        this.numStoreFailed.set(0);
        this.consumer = new ConcurrentRecordConsumer(this);
        ThreadPool.run(this.consumer);
        this.waitingForQueueDone = true;
        this.source.fetchSince(this.source.getLastSyncTimestamp(), this);
    }

    public void beginAndFlow() throws InvalidSessionTransitionException {
        Logger.trace(LOG_TAG, "Beginning source.");
        this.source.begin(this);
    }

    @Override
    public void store(Record record) {
        this.numStored.incrementAndGet();
        try {
            this.sink.store(record);
        }
        catch (NoStoreDelegateException noStoreDelegateException) {
            Logger.error(LOG_TAG, "Got NoStoreDelegateException in RecordsChannel.store(). This should not occur. Aborting.", noStoreDelegateException);
            this.delegate.onFlowStoreFailed(this, noStoreDelegateException, record.guid);
        }
    }

    @Override
    public void onFetchFailed(Exception exception, Record record) {
        Logger.warn(LOG_TAG, "onFetchFailed. Calling for immediate stop.", exception);
        this.numFetchFailed.incrementAndGet();
        this.consumer.halt();
        this.delegate.onFlowFetchFailed(this, exception);
    }

    @Override
    public void onFetchedRecord(Record record) {
        this.numFetched.incrementAndGet();
        this.toProcess.add(record);
        this.consumer.doNotify();
    }

    @Override
    public void onFetchCompleted(long l) {
        Logger.trace(LOG_TAG, "onFetchCompleted. Stopping consumer once stores are done.");
        Logger.trace(LOG_TAG, "Fetch timestamp is " + l);
        this.fetchEnd = l;
        this.consumer.queueFilled();
    }

    @Override
    public void onRecordStoreFailed(Exception exception, String string2) {
        Logger.trace(LOG_TAG, "Failed to store record with guid " + string2);
        this.numStoreFailed.incrementAndGet();
        this.consumer.stored();
        this.delegate.onFlowStoreFailed(this, exception, string2);
    }

    @Override
    public void onRecordStoreSucceeded(String string2) {
        Logger.trace(LOG_TAG, "Stored record with guid " + string2);
        this.consumer.stored();
    }

    @Override
    public void consumerIsDone(boolean bl) {
        Logger.trace(LOG_TAG, "Consumer is done. Are we waiting for it? " + this.waitingForQueueDone);
        if (this.waitingForQueueDone) {
            this.waitingForQueueDone = false;
            this.sink.storeDone();
        }
    }

    @Override
    public void onStoreCompleted(long l) {
        Logger.trace(LOG_TAG, "onStoreCompleted. Notifying delegate of onFlowCompleted. Fetch end is " + this.fetchEnd + ", store end is " + l);
        this.delegate.onFlowCompleted(this, this.fetchEnd, l);
    }

    @Override
    public void onBeginFailed(Exception exception) {
        this.delegate.onFlowBeginFailed(this, exception);
    }

    @Override
    public void onBeginSucceeded(RepositorySession repositorySession) {
        if (repositorySession == this.source) {
            Logger.trace(LOG_TAG, "Source session began. Beginning sink session.");
            try {
                this.sink.begin(this);
            }
            catch (InvalidSessionTransitionException invalidSessionTransitionException) {
                this.onBeginFailed(invalidSessionTransitionException);
                return;
            }
        }
        if (repositorySession == this.sink) {
            Logger.trace(LOG_TAG, "Sink session began. Beginning flow.");
            this.flow();
            return;
        }
    }

    @Override
    public RepositorySessionStoreDelegate deferredStoreDelegate(ExecutorService executorService) {
        return new DeferredRepositorySessionStoreDelegate(this, executorService);
    }

    @Override
    public RepositorySessionBeginDelegate deferredBeginDelegate(ExecutorService executorService) {
        return new DeferredRepositorySessionBeginDelegate(this, executorService);
    }

    @Override
    public RepositorySessionFetchRecordsDelegate deferredFetchDelegate(ExecutorService executorService) {
        return this;
    }
}

