/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.webapp;

import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoApp;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.webapp.Allocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UninstallListener
extends BroadcastReceiver {
    private static String LOGTAG = "GeckoWebappUninstallListener";

    public void onReceive(Context context, Intent intent) {
        if (intent.getBooleanExtra("android.intent.extra.REPLACING", false)) {
            Log.i((String)LOGTAG, (String)"Package is being replaced; ignoring removal intent");
            return;
        }
        String string2 = intent.getData().getSchemeSpecificPart();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            Log.i((String)LOGTAG, (String)"No package name defined in intent");
            return;
        }
        Allocator allocator = Allocator.getInstance(context);
        ArrayList<String> arrayList = allocator.getInstalledPackageNames();
        if (arrayList.contains(string2)) {
            UninstallListener.doUninstall(context, string2);
        }
    }

    private static void doUninstall(Context context, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        UninstallListener.doUninstall(context, arrayList);
    }

    private static void doUninstall(Context context, ArrayList<String> arrayList) {
        Allocator allocator = Allocator.getInstance(context);
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        for (String string2 : arrayList) {
            jSONArray.put((Object)string2);
            int n = allocator.getIndexForApp(string2);
            if (n == -1) continue;
            allocator.releaseIndex(n);
            String string3 = context.getPackageName();
            string3 = string3 + ":" + string3 + ".Webapp" + n;
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            List list = activityManager.getRunningAppProcesses();
            if (list != null) {
                for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                    if (!runningAppProcessInfo.processName.equals(string3)) continue;
                    Process.killProcess((int)runningAppProcessInfo.pid);
                    break;
                }
            }
            GeckoProfile.removeProfile(context, "webapp" + n);
        }
        try {
            jSONObject.put("apkPackageNames", (Object)jSONArray);
            GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Webapps:AutoUninstall", jSONObject.toString()));
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"Error sending uninstall packages to Gecko", (Throwable)jSONException);
        }
    }

    public static void initUninstallPackageScan(Context context) {
        Allocator allocator = Allocator.getInstance(context);
        ArrayList<String> arrayList = allocator.getInstalledPackageNames();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.getInstalledApplications(128);
        HashSet<String> hashSet = new HashSet<String>();
        for (ApplicationInfo object : list) {
            hashSet.add(object.packageName);
        }
        for (String string2 : arrayList) {
            if (hashSet.contains(string2)) continue;
            arrayList2.add(string2);
        }
        if (arrayList2.size() > 0) {
            UninstallListener.doUninstall(context, arrayList2);
        }
    }

    public static class DelayedStartupTask
    implements Runnable {
        private GeckoApp mApp;

        public DelayedStartupTask(GeckoApp geckoApp) {
            this.mApp = geckoApp;
        }

        public void run() {
            ThreadUtils.assertOnBackgroundThread();
            UninstallListener.initUninstallPackageScan(this.mApp.getApplicationContext());
        }
    }
}

