/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import org.mozilla.gecko.R;
import org.mozilla.gecko.util.HardwareUtils;

public abstract class ArrowPopup
extends PopupWindow {
    private View mAnchor;
    private ImageView mArrow;
    private int mArrowWidth;
    private int mYOffset;
    protected LinearLayout mContent;
    protected boolean mInflated;
    protected final Context mContext;

    public ArrowPopup(Context context) {
        super(context);
        this.mContext = context;
        Resources resources = context.getResources();
        this.mArrowWidth = resources.getDimensionPixelSize(R.dimen.arrow_popup_arrow_width);
        this.mYOffset = resources.getDimensionPixelSize(R.dimen.arrow_popup_arrow_offset);
        this.setAnimationStyle(R.style.PopupAnimation);
    }

    protected void init() {
        this.setBackgroundDrawable((Drawable)new BitmapDrawable(this.mContext.getResources()));
        this.setOutsideTouchable(true);
        int n = HardwareUtils.isTablet() ? -2 : -1;
        this.setWindowLayoutMode(n, -2);
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.mContext);
        final ArrowPopupLayout arrowPopupLayout = (ArrowPopupLayout)layoutInflater.inflate(R.layout.arrow_popup, null);
        this.setContentView((View)arrowPopupLayout);
        arrowPopupLayout.mListener = new ArrowPopupLayout.OnSizeChangedListener(){

            public void onSizeChanged() {
                if (ArrowPopup.this.mAnchor == null) {
                    return;
                }
                int n = ArrowPopup.this.mAnchor.getWidth() - ArrowPopup.this.mAnchor.getPaddingLeft() - ArrowPopup.this.mAnchor.getPaddingRight();
                int n2 = (n - ArrowPopup.this.mArrowWidth) / 2 + ArrowPopup.this.mAnchor.getPaddingLeft();
                int[] nArray = new int[2];
                ArrowPopup.this.mAnchor.getLocationOnScreen(nArray);
                int n3 = nArray[0];
                arrowPopupLayout.getLocationOnScreen(nArray);
                int n4 = nArray[0];
                int n5 = n3 - n4 + n2;
                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)ArrowPopup.this.mArrow.getLayoutParams();
                layoutParams.setMargins(n5, 0, 0, 0);
            }
        };
        this.mArrow = (ImageView)arrowPopupLayout.findViewById(R.id.arrow);
        this.mContent = (LinearLayout)arrowPopupLayout.findViewById(R.id.content);
        this.mInflated = true;
    }

    public void setAnchor(View view) {
        this.mAnchor = view;
    }

    public void show() {
        if (!this.mInflated) {
            throw new IllegalStateException("ArrowPopup#init() must be called before ArrowPopup#show()");
        }
        int[] nArray = new int[2];
        if (this.mAnchor != null) {
            this.mAnchor.getLocationInWindow(nArray);
        }
        if (this.mAnchor == null || nArray[1] < 0) {
            View view = ((Activity)this.mContext).getWindow().getDecorView();
            if (Build.VERSION.SDK_INT < 11) {
                this.setWidth(view.getWidth());
                this.setHeight(view.getHeight());
            }
            this.showAtLocation(view, 0, nArray[0] - this.mArrowWidth, 0);
            return;
        }
        if (this.isShowing()) {
            this.update(this.mAnchor, -this.mArrowWidth, -this.mYOffset, -1, -1);
        } else {
            this.showAsDropDown(this.mAnchor, -this.mArrowWidth, -this.mYOffset);
        }
    }

    private static class ArrowPopupLayout
    extends RelativeLayout {
        private OnSizeChangedListener mListener;

        public ArrowPopupLayout(Context context, AttributeSet attributeSet, int n) {
            super(context, attributeSet, n);
        }

        public ArrowPopupLayout(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public ArrowPopupLayout(Context context) {
            super(context);
        }

        protected void onSizeChanged(int n, int n2, int n3, int n4) {
            super.onSizeChanged(n, n2, n3, n4);
            this.mListener.onSizeChanged();
        }

        public static interface OnSizeChangedListener {
            public void onSizeChanged();
        }
    }
}

