/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import android.util.Log;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.mozilla.gecko.mozglue.RobocopTarget;

public class FileUtils {
    private static final String LOGTAG = "GeckoFileUtils";

    @RobocopTarget
    public static void delTree(File file, FilenameFilter filenameFilter, boolean bl) {
        String[] stringArray = null;
        stringArray = filenameFilter != null ? file.list(filenameFilter) : file.list();
        if (stringArray == null) {
            return;
        }
        for (String string : stringArray) {
            File file2 = new File(file, string);
            FileUtils.delete(file2, bl);
        }
    }

    public static boolean delete(File file) throws IOException {
        return FileUtils.delete(file, true);
    }

    public static boolean delete(File file, boolean bl) {
        if (file.isDirectory() && bl) {
            String[] stringArray;
            for (String string : stringArray = file.list()) {
                File file2 = new File(file, string);
                try {
                    FileUtils.delete(file2);
                }
                catch (IOException iOException) {
                    Log.i((String)LOGTAG, (String)("Error deleting " + file2.getPath()), (Throwable)iOException);
                }
            }
        }
        return file.delete();
    }

    public static class NameAndAgeFilter
    implements FilenameFilter {
        private final String mName;
        private final double mMaxAge;

        public NameAndAgeFilter(String string, double d) {
            this.mName = string;
            this.mMaxAge = d;
        }

        public boolean accept(File file, String string) {
            if (this.mName == null || this.mName.matches(string)) {
                File file2 = new File(file, string);
                if (this.mMaxAge < 0.0 || (double)(System.currentTimeMillis() - file2.lastModified()) > this.mMaxAge) {
                    return true;
                }
            }
            return false;
        }
    }
}

