/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.mozilla.gecko.util.INISection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class INIParser
extends INISection {
    private File mFile = null;
    private Hashtable<String, INISection> mSections = null;

    public INIParser(File file) {
        super("");
        this.mFile = file;
    }

    public void write() {
        this.writeTo(this.mFile);
    }

    public void writeTo(File file) {
        if (file == null) {
            return;
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        try {
            this.write(bufferedWriter);
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void write(BufferedWriter bufferedWriter) throws IOException {
        super.write(bufferedWriter);
        if (this.mSections != null) {
            Enumeration<INISection> enumeration = this.mSections.elements();
            while (enumeration.hasMoreElements()) {
                INISection iNISection = enumeration.nextElement();
                iNISection.write(bufferedWriter);
                bufferedWriter.newLine();
            }
        }
    }

    public Hashtable<String, INISection> getSections() {
        if (this.mSections == null) {
            try {
                this.parse();
            }
            catch (IOException iOException) {
                this.debug("Error parsing: " + iOException);
            }
        }
        return this.mSections;
    }

    @Override
    protected void parse() throws IOException {
        super.parse();
        this.parse(this.mFile);
    }

    private void parse(File file) throws IOException {
        this.mSections = new Hashtable();
        if (file == null || !file.exists()) {
            return;
        }
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        String string = null;
        INISection iNISection = null;
        while ((string = bufferedReader.readLine()) != null) {
            if (string != null) {
                string = string.trim();
            }
            if (string == null || string.length() == 0 || string.charAt(0) == ';') {
                this.debug("Ignore line: " + string);
                continue;
            }
            if (string.charAt(0) == '[') {
                this.debug("Parse as section: " + string);
                iNISection = new INISection(string.substring(1, string.length() - 1));
                this.mSections.put(iNISection.getName(), iNISection);
                continue;
            }
            this.debug("Parse as property: " + string);
            String[] stringArray = string.split("=");
            if (stringArray.length != 2) continue;
            String string2 = stringArray[0].trim();
            String string3 = stringArray[1].trim();
            if (iNISection != null) {
                iNISection.setProperty(string2, string3);
                continue;
            }
            this.mProperties.put(string2, string3);
        }
        bufferedReader.close();
    }

    public void addSection(INISection iNISection) {
        this.getSections();
        this.mSections.put(iNISection.getName(), iNISection);
    }

    public INISection getSection(String string) {
        this.getSections();
        return this.mSections.get(string);
    }

    public void removeSection(String string) {
        this.getSections();
        this.mSections.remove(string);
    }

    public void renameSection(String string, String string2) {
        this.getSections();
        this.mSections.remove(string2);
        INISection iNISection = this.mSections.get(string);
        if (iNISection == null) {
            return;
        }
        iNISection.setName(string2);
        this.mSections.remove(string);
        this.mSections.put(string2, iNISection);
    }
}

