/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import android.net.Uri;
import android.text.TextUtils;

public class StringUtils {
    private static final String FILTER_URL_PREFIX = "filter://";

    public static boolean isSearchQuery(String string, boolean bl) {
        if ((string = string.trim()).length() == 0) {
            return bl;
        }
        int n = string.indexOf(58);
        int n2 = string.indexOf(46);
        int n3 = string.indexOf(32);
        if (!(n3 <= -1 || n != -1 && n3 >= n || n2 != -1 && n3 >= n2)) {
            return true;
        }
        if (n2 > -1 || n > -1) {
            return false;
        }
        return bl;
    }

    public static String stripScheme(String string) {
        return StringUtils.stripScheme(string, 0);
    }

    public static String stripScheme(String string, int n) {
        if (string == null) {
            return string;
        }
        int n2 = 0;
        int n3 = string.length();
        if (string.startsWith("http://")) {
            n2 = 7;
        } else if (string.startsWith("https://") && n == 1) {
            n2 = 8;
        }
        if (string.endsWith("/")) {
            --n3;
        }
        return string.substring(n2, n3);
    }

    public static String stripCommonSubdomains(String string) {
        if (string == null) {
            return string;
        }
        int n = 0;
        if (string.startsWith("www.")) {
            n = 4;
        } else if (string.startsWith("mobile.")) {
            n = 7;
        } else if (string.startsWith("m.")) {
            n = 2;
        }
        return string.substring(n);
    }

    public static String getQueryParameter(String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        String[] stringArray = string.split("\\?");
        if (stringArray.length < 2) {
            return null;
        }
        String string3 = stringArray[1];
        for (String string4 : string3.split("&")) {
            String[] stringArray2 = string4.split("=");
            String string5 = Uri.decode((String)stringArray2[0]);
            if (TextUtils.isEmpty((CharSequence)string5) || !string5.equals(string2) || stringArray2.length < 2) continue;
            String string6 = Uri.decode((String)stringArray2[1]);
            if (TextUtils.isEmpty((CharSequence)string6)) {
                return null;
            }
            return string6;
        }
        return null;
    }

    public static boolean isFilterUrl(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        return string.startsWith(FILTER_URL_PREFIX);
    }

    public static String getFilterFromUrl(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return string.substring(FILTER_URL_PREFIX.length());
    }

    public static boolean isShareableUrl(String string) {
        String string2 = Uri.parse((String)string).getScheme();
        return !"about".equals(string2) && !"chrome".equals(string2) && !"file".equals(string2) && !"resource".equals(string2);
    }

    public static class UrlFlags {
        public static final int NONE = 0;
        public static final int STRIP_HTTPS = 1;
    }
}

