/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import android.os.Handler;
import android.os.MessageQueue;
import android.util.Log;
import java.util.Map;
import org.mozilla.gecko.mozglue.RobocopTarget;
import org.mozilla.gecko.util.GeckoBackgroundThread;

public final class ThreadUtils {
    private static final String LOGTAG = "ThreadUtils";
    private static volatile Thread sUiThread;
    private static volatile Thread sBackgroundThread;
    private static Handler sUiHandler;
    public static Handler sGeckoHandler;
    public static MessageQueue sGeckoQueue;
    public static Thread sGeckoThread;
    private static final Runnable sPriorityResetRunnable;
    private static boolean sIsGeckoPriorityReduced;

    public static void dumpAllStackTraces() {
        Log.w((String)LOGTAG, (String)"Dumping ALL the threads!");
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        for (Thread thread : map.keySet()) {
            Log.w((String)LOGTAG, (String)thread.toString());
            for (StackTraceElement stackTraceElement : map.get(thread)) {
                Log.w((String)LOGTAG, (String)stackTraceElement.toString());
            }
            Log.w((String)LOGTAG, (String)"----");
        }
    }

    public static void setUiThread(Thread thread, Handler handler) {
        sUiThread = thread;
        sUiHandler = handler;
    }

    public static void setBackgroundThread(Thread thread) {
        sBackgroundThread = thread;
    }

    public static Thread getUiThread() {
        return sUiThread;
    }

    public static Handler getUiHandler() {
        return sUiHandler;
    }

    public static void postToUiThread(Runnable runnable) {
        sUiHandler.post(runnable);
    }

    public static Thread getBackgroundThread() {
        return sBackgroundThread;
    }

    public static Handler getBackgroundHandler() {
        return GeckoBackgroundThread.getHandler();
    }

    public static void postToBackgroundThread(Runnable runnable) {
        GeckoBackgroundThread.post(runnable);
    }

    public static void assertOnUiThread(AssertBehavior assertBehavior) {
        ThreadUtils.assertOnThread(ThreadUtils.getUiThread(), assertBehavior);
    }

    public static void assertOnUiThread() {
        ThreadUtils.assertOnThread(ThreadUtils.getUiThread(), AssertBehavior.THROW);
    }

    public static void assertNotOnUiThread() {
        ThreadUtils.assertNotOnThread(ThreadUtils.getUiThread(), AssertBehavior.THROW);
    }

    @RobocopTarget
    public static void assertOnGeckoThread() {
        ThreadUtils.assertOnThread(sGeckoThread, AssertBehavior.THROW);
    }

    public static void assertOnBackgroundThread() {
        ThreadUtils.assertOnThread(ThreadUtils.getBackgroundThread(), AssertBehavior.THROW);
    }

    public static void assertOnThread(Thread thread) {
        ThreadUtils.assertOnThread(thread, AssertBehavior.THROW);
    }

    public static void assertOnThread(Thread thread, AssertBehavior assertBehavior) {
        ThreadUtils.assertOnThreadComparison(thread, assertBehavior, true);
    }

    public static void assertNotOnThread(Thread thread, AssertBehavior assertBehavior) {
        ThreadUtils.assertOnThreadComparison(thread, assertBehavior, false);
    }

    private static void assertOnThreadComparison(Thread thread, AssertBehavior assertBehavior, boolean bl) {
        long l;
        Thread thread2 = Thread.currentThread();
        long l2 = thread2.getId();
        if (l2 == (l = thread.getId()) == bl) {
            return;
        }
        String string = "Expected thread " + l + " (\"" + thread.getName() + "\"), but running on thread " + l2 + " (\"" + thread2.getName() + ")";
        IllegalThreadStateException illegalThreadStateException = new IllegalThreadStateException(string);
        switch (assertBehavior) {
            case THROW: {
                throw illegalThreadStateException;
            }
        }
        Log.e((String)LOGTAG, (String)"Method called on wrong thread!", (Throwable)illegalThreadStateException);
    }

    public static boolean isOnUiThread() {
        return ThreadUtils.isOnThread(ThreadUtils.getUiThread());
    }

    public static boolean isOnBackgroundThread() {
        if (sBackgroundThread == null) {
            return false;
        }
        return ThreadUtils.isOnThread(sBackgroundThread);
    }

    public static boolean isOnThread(Thread thread) {
        return Thread.currentThread().getId() == thread.getId();
    }

    public static void reduceGeckoPriority(long l) {
        if (!sIsGeckoPriorityReduced) {
            sIsGeckoPriorityReduced = true;
            sGeckoThread.setPriority(1);
            ThreadUtils.getUiHandler().postDelayed(sPriorityResetRunnable, l);
        }
    }

    public static void resetGeckoPriority() {
        if (sIsGeckoPriorityReduced) {
            sIsGeckoPriorityReduced = false;
            sGeckoThread.setPriority(5);
            ThreadUtils.getUiHandler().removeCallbacks(sPriorityResetRunnable);
        }
    }

    static {
        sPriorityResetRunnable = new Runnable(){

            public void run() {
                ThreadUtils.resetGeckoPriority();
            }
        };
    }

    public static class UiThreadBlockedException
    extends RuntimeException {
        public UiThreadBlockedException() {
        }

        public UiThreadBlockedException(String string) {
            super(string);
        }

        public UiThreadBlockedException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public UiThreadBlockedException(Throwable throwable) {
            super(throwable);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AssertBehavior {
        NONE,
        THROW;

    }
}

