/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.message;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HeaderIterator;
import java.util.NoSuchElementException;

public class BasicHeaderIterator
implements HeaderIterator {
    protected final Header[] allHeaders;
    protected int currentIndex;
    protected String headerName;

    public BasicHeaderIterator(Header[] headerArray, String string) {
        if (headerArray == null) {
            throw new IllegalArgumentException("Header array must not be null.");
        }
        this.allHeaders = headerArray;
        this.headerName = string;
        this.currentIndex = this.findNext(-1);
    }

    protected int findNext(int n) {
        if (n < -1) {
            return -1;
        }
        int n2 = this.allHeaders.length - 1;
        boolean bl = false;
        while (!bl && n < n2) {
            bl = this.filterHeader(++n);
        }
        return bl ? n : -1;
    }

    protected boolean filterHeader(int n) {
        return this.headerName == null || this.headerName.equalsIgnoreCase(this.allHeaders[n].getName());
    }

    public boolean hasNext() {
        return this.currentIndex >= 0;
    }

    public Header nextHeader() throws NoSuchElementException {
        int n = this.currentIndex;
        if (n < 0) {
            throw new NoSuchElementException("Iteration already finished.");
        }
        this.currentIndex = this.findNext(n);
        return this.allHeaders[n];
    }

    public final Object next() throws NoSuchElementException {
        return this.nextHeader();
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Removing headers is not supported.");
    }
}

