/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

final class MarkableInputStream
extends InputStream {
    private final InputStream in;
    private long offset;
    private long reset;
    private long limit;
    private long defaultMark = -1L;

    public MarkableInputStream(InputStream inputStream) {
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        this.in = inputStream;
    }

    public void mark(int n) {
        this.defaultMark = this.savePosition(n);
    }

    public long savePosition(int n) {
        long l = this.offset + (long)n;
        if (this.limit < l) {
            this.setLimit(l);
        }
        return this.offset;
    }

    private void setLimit(long l) {
        try {
            if (this.reset < this.offset && this.offset <= this.limit) {
                this.in.reset();
                this.in.mark((int)(l - this.reset));
                this.skip(this.reset, this.offset);
            } else {
                this.reset = this.offset;
                this.in.mark((int)(l - this.offset));
            }
            this.limit = l;
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Unable to mark: " + iOException);
        }
    }

    public void reset() throws IOException {
        this.reset(this.defaultMark);
    }

    public void reset(long l) throws IOException {
        if (this.offset > this.limit || l < this.reset) {
            throw new IOException("Cannot reset");
        }
        this.in.reset();
        this.skip(this.reset, l);
        this.offset = l;
    }

    private void skip(long l, long l2) throws IOException {
        while (l < l2) {
            long l3 = this.in.skip(l2 - l);
            if (l3 == 0L) {
                if (this.read() == -1) break;
                l3 = 1L;
            }
            l += l3;
        }
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (n != -1) {
            ++this.offset;
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.in.read(byArray);
        if (n != -1) {
            this.offset += (long)n;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (n3 != -1) {
            this.offset += (long)n3;
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        long l2 = this.in.skip(l);
        this.offset += l2;
        return l2;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }
}

