/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.util.Log;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.gfx.BitmapUtils;
import org.mozilla.gecko.util.ThreadUtils;

public class WebappAllocator {
    private final String LOGTAG = "GeckoWebappAllocator";
    private static final int MAX_WEB_APPS = 100;
    protected static WebappAllocator sInstance = null;
    SharedPreferences mPrefs;

    public static WebappAllocator getInstance() {
        return WebappAllocator.getInstance(GeckoAppShell.getContext());
    }

    public static synchronized WebappAllocator getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new WebappAllocator(context);
        }
        return sInstance;
    }

    protected WebappAllocator(Context context) {
        this.mPrefs = context.getSharedPreferences("webapps", 4);
    }

    public static String appKey(int n) {
        return "app" + n;
    }

    public static String iconKey(int n) {
        return "icon" + n;
    }

    public synchronized int findAndAllocateIndex(String string2, String string3, String string4) {
        Bitmap bitmap = string4 != null ? BitmapUtils.getBitmapFromDataURI(string4) : null;
        return this.findAndAllocateIndex(string2, string3, bitmap);
    }

    public synchronized int findAndAllocateIndex(String string2, String string3, Bitmap bitmap) {
        int n = this.getIndexForApp(string2);
        if (n != -1) {
            return n;
        }
        for (int i = 0; i < 100; ++i) {
            if (this.mPrefs.contains(WebappAllocator.appKey(i))) continue;
            this.updateAppAllocation(string2, i, bitmap);
            return i;
        }
        return -1;
    }

    public synchronized void updateAppAllocation(final String string2, final int n, final Bitmap bitmap) {
        if (bitmap != null) {
            ThreadUtils.getBackgroundHandler().post(new Runnable(){

                public void run() {
                    int n2 = 0;
                    try {
                        n2 = BitmapUtils.getDominantColor(bitmap);
                    }
                    catch (Exception exception) {
                        Log.e((String)"GeckoWebappAllocator", (String)"Exception during getDominantColor", (Throwable)exception);
                    }
                    WebappAllocator.this.mPrefs.edit().putString(WebappAllocator.appKey(n), string2).putInt(WebappAllocator.iconKey(n), n2).commit();
                }
            });
        } else {
            this.mPrefs.edit().putString(WebappAllocator.appKey(n), string2).putInt(WebappAllocator.iconKey(n), 0).commit();
        }
    }

    public synchronized int getIndexForApp(String string2) {
        for (int i = 0; i < 100; ++i) {
            if (!this.mPrefs.getString(WebappAllocator.appKey(i), "").equals(string2)) continue;
            return i;
        }
        return -1;
    }

    public synchronized String getAppForIndex(int n) {
        return this.mPrefs.getString(WebappAllocator.appKey(n), null);
    }

    public synchronized int releaseIndexForApp(String string2) {
        int n = this.getIndexForApp(string2);
        if (n == -1) {
            return -1;
        }
        this.releaseIndex(n);
        return n;
    }

    public synchronized void releaseIndex(final int n) {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            public void run() {
                WebappAllocator.this.mPrefs.edit().remove(WebappAllocator.appKey(n)).remove(WebappAllocator.iconKey(n)).commit();
            }
        });
    }
}

