/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.text.TextUtils;
import android.util.Log;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.R;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.gecko.mozglue.RobocopTarget;
import org.mozilla.gecko.util.RawResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RobocopTarget
public class SuggestedSites {
    private static final String LOGTAG = "GeckoSuggestedSites";
    private static final String[] COLUMNS = new String[]{"_id", "url", "title"};
    private static final String JSON_KEY_URL = "url";
    private static final String JSON_KEY_TITLE = "title";
    private static final String JSON_KEY_IMAGE_URL = "imageurl";
    private static final String JSON_KEY_BG_COLOR = "bgcolor";
    private final Context context;
    private Map<String, Site> cachedSites;
    private Locale cachedLocale;

    public SuggestedSites(Context context) {
        this.context = context;
    }

    private String loadFromFile() {
        return null;
    }

    private String loadFromResource() {
        try {
            return RawResource.getAsString((Context)this.context, (int)R.raw.suggestedsites);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void refresh() {
        Log.d((String)LOGTAG, (String)"Refreshing tiles from file");
        String string2 = this.loadFromFile();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            Log.d((String)LOGTAG, (String)"No suggested sites file, loading from resource.");
            string2 = this.loadFromResource();
        }
        LinkedHashMap<String, Site> linkedHashMap = null;
        try {
            JSONArray jSONArray = new JSONArray(string2);
            linkedHashMap = new LinkedHashMap<String, Site>(jSONArray.length());
            int n = jSONArray.length();
            for (int i = 0; i < n; ++i) {
                JSONObject jSONObject = (JSONObject)jSONArray.get(i);
                String string3 = jSONObject.getString(JSON_KEY_URL);
                Site site = new Site(string3, jSONObject.getString(JSON_KEY_TITLE), jSONObject.getString(JSON_KEY_IMAGE_URL), jSONObject.getString(JSON_KEY_BG_COLOR));
                linkedHashMap.put(string3, site);
            }
            Log.d((String)LOGTAG, (String)"Successfully parsed suggested sites.");
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"Failed to refresh suggested sites", (Throwable)exception);
            return;
        }
        this.cachedSites = Collections.unmodifiableMap(linkedHashMap);
        this.cachedLocale = Locale.getDefault();
    }

    private boolean isEnabled() {
        SharedPreferences sharedPreferences = GeckoSharedPrefs.forApp(this.context);
        return sharedPreferences.getBoolean("android.not_a_preference.home_suggested_sites", true);
    }

    private Site getSiteForUrl(String string2) {
        if (this.cachedSites == null) {
            return null;
        }
        return this.cachedSites.get(string2);
    }

    public Cursor get(int n) {
        return this.get(n, Locale.getDefault());
    }

    public Cursor get(int n, Locale locale) {
        return this.get(n, locale, null);
    }

    public Cursor get(int n, List<String> list) {
        return this.get(n, Locale.getDefault(), list);
    }

    public Cursor get(int n, Locale locale, List<String> list) {
        MatrixCursor matrixCursor = new MatrixCursor(COLUMNS);
        if (!this.isEnabled()) {
            return matrixCursor;
        }
        if (this.cachedSites == null || !locale.equals(this.cachedLocale)) {
            Log.d((String)LOGTAG, (String)"No cached sites, refreshing.");
            this.refresh();
        }
        if (this.cachedSites == null || this.cachedSites.isEmpty()) {
            return matrixCursor;
        }
        int n2 = this.cachedSites.size();
        Log.d((String)LOGTAG, (String)("Number of suggested sites: " + n2));
        int n3 = Math.min(n, n2);
        for (Site site : this.cachedSites.values()) {
            if (matrixCursor.getCount() == n3) break;
            if (list != null && list.contains(site.url)) continue;
            MatrixCursor.RowBuilder rowBuilder = matrixCursor.newRow();
            rowBuilder.add((Object)-1);
            rowBuilder.add((Object)site.url);
            rowBuilder.add((Object)site.title);
        }
        matrixCursor.setNotificationUri(this.context.getContentResolver(), BrowserContract.SuggestedSites.CONTENT_URI);
        return matrixCursor;
    }

    public boolean contains(String string2) {
        return this.getSiteForUrl(string2) != null;
    }

    public String getImageUrlForUrl(String string2) {
        Site site = this.getSiteForUrl(string2);
        return site != null ? site.imageUrl : null;
    }

    public String getBackgroundColorForUrl(String string2) {
        Site site = this.getSiteForUrl(string2);
        return site != null ? site.bgColor : null;
    }

    private static class Site {
        public final String url;
        public final String title;
        public final String imageUrl;
        public final String bgColor;

        public Site(String string2, String string3, String string4, String string5) {
            this.url = string2;
            this.title = string3;
            this.imageUrl = string4;
            this.bgColor = string5;
        }

        public String toString() {
            return "{ url = " + this.url + "\n" + "title = " + this.title + "\n" + "imageUrl = " + this.imageUrl + "\n" + "bgColor = " + this.bgColor + " }";
        }
    }
}

